/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.IOException;
import java.io.InputStream;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoSessionInputStream
extends InputStream {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Object m_mutex = new Object();
    private final ByteBuffer m_buf;
    private volatile boolean m_closed;
    private volatile boolean m_released;
    private IOException m_exception;
    private final IoSession m_ioSession;
    private final int m_readTimeout;
    private volatile int m_rawBytesReceived = 0;
    private volatile int m_totalReadBytes;

    public IoSessionInputStream(IoSession ioSession, int readTimeout) {
        this.m_ioSession = ioSession;
        this.m_readTimeout = readTimeout;
        this.m_buf = ByteBuffer.allocate((int)16);
        this.m_buf.setAutoExpand(true);
        this.m_buf.limit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        if (this.m_released) {
            return 0;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            return this.m_buf.remaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.m_log.debug("Closing input stream...");
        if (this.m_closed) {
            return;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_closed = true;
            this.releaseBuffer();
            this.m_mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.m_mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                return -1;
            }
            return this.m_buf.get() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.m_log.debug("Reading data...");
        Object object = this.m_mutex;
        synchronized (object) {
            if (!this.waitForData()) {
                this.m_log.debug("Not waiting for data...");
                return -1;
            }
            this.m_log.debug("Continuing with read...");
            int readBytes = len > this.m_buf.remaining() ? this.m_buf.remaining() : len;
            this.m_log.debug("Copying bytes...");
            this.m_buf.get(b, off, readBytes);
            this.m_totalReadBytes += readBytes;
            this.m_log.debug("Total read bytes: {}", (Object)this.m_totalReadBytes);
            return readBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForData() throws IOException {
        if (this.m_released) {
            this.m_log.debug("Released...");
            return false;
        }
        Object object = this.m_mutex;
        synchronized (object) {
            while (!this.m_released && this.m_buf.remaining() == 0 && this.m_exception == null) {
                try {
                    this.m_log.debug("Waiting for data for: " + this.m_readTimeout);
                    this.m_mutex.wait(this.m_readTimeout);
                }
                catch (InterruptedException e) {
                    IOException ioe = new IOException("Interrupted while waiting for more data");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
        }
        if (this.m_exception != null) {
            this.releaseBuffer();
            throw this.m_exception;
        }
        if (this.m_closed && this.m_buf.remaining() == 0) {
            this.releaseBuffer();
            return false;
        }
        return true;
    }

    private void releaseBuffer() {
        if (this.m_released) {
            return;
        }
        this.m_released = true;
        this.m_buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer src) {
        this.m_log.debug("Writing data to input stream...");
        this.m_rawBytesReceived += src.remaining();
        this.m_log.debug("Received raw bytes: {}", (Object)this.m_rawBytesReceived);
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_closed) {
                this.m_log.debug("InputStream closed...");
                return;
            }
            if (this.m_buf.hasRemaining()) {
                this.m_log.debug("Copying buffer data...");
                this.m_buf.compact();
                this.m_buf.put(src);
                this.m_buf.flip();
                this.m_mutex.notifyAll();
            } else {
                this.m_log.debug("Nothing remaining in buffer...");
                this.m_buf.clear();
                this.m_buf.put(src);
                this.m_buf.flip();
                this.m_mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwException(IOException e) {
        Object object = this.m_mutex;
        synchronized (object) {
            if (this.m_exception == null) {
                this.m_exception = e;
                this.m_mutex.notifyAll();
            }
        }
    }
}

