/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.transport.socket.nio.SocketSessionConfig;
import org.littleshoot.util.NotYetImplementedException;
import org.littleshoot.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoSessionSocket
extends Socket {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final IoSession m_ioSession;
    private final InputStream m_in;
    private final OutputStream m_out;
    private final SocketSessionConfig m_socketSessionConfig;

    public IoSessionSocket(IoSession ioSession, InputStream in, OutputStream out) {
        this.m_ioSession = ioSession;
        this.m_in = in;
        this.m_out = out;
        this.m_socketSessionConfig = (SocketSessionConfig)ioSession.getConfig();
        this.m_socketSessionConfig.setKeepAlive(true);
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.m_log.warn("Attempting to bind to local address...");
        throw new NotYetImplementedException();
    }

    @Override
    public void close() throws IOException {
        this.m_log.debug("Closing socket from: " + ThreadUtils.dumpStack());
        this.m_ioSession.close();
    }

    @Override
    public void connect(SocketAddress address) throws IOException {
        this.connect(address, 60000);
    }

    @Override
    public void connect(SocketAddress address, int timeout) throws IOException {
        this.m_log.warn("We should already be connected!!");
    }

    @Override
    public SocketChannel getChannel() {
        this.m_log.warn("Not implemented!!!");
        throw new NotYetImplementedException();
    }

    @Override
    public InetAddress getInetAddress() {
        return ((InetSocketAddress)this.m_ioSession.getRemoteAddress()).getAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.m_log.debug("Returning input stream...");
        return this.m_in;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return false;
    }

    @Override
    public InetAddress getLocalAddress() {
        return ((InetSocketAddress)this.m_ioSession.getLocalAddress()).getAddress();
    }

    @Override
    public int getLocalPort() {
        return ((InetSocketAddress)this.m_ioSession.getLocalAddress()).getPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.m_ioSession.getLocalAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.m_log.debug("Returning output stream...");
        return this.m_out;
    }

    @Override
    public int getPort() {
        return ((InetSocketAddress)this.m_ioSession.getRemoteAddress()).getPort();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.m_socketSessionConfig.getReceiveBufferSize();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.m_ioSession.getRemoteAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.m_socketSessionConfig.isReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.m_socketSessionConfig.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.m_socketSessionConfig.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        this.m_log.warn("Not implemented!!!");
        throw new NotYetImplementedException("SO_TIMEOUT not implemented");
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.m_socketSessionConfig.isTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.m_socketSessionConfig.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return !this.m_ioSession.isConnected();
    }

    @Override
    public boolean isConnected() {
        return this.m_ioSession.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        this.m_log.warn("Not implemented!!!");
        throw new NotYetImplementedException();
    }

    @Override
    public boolean isOutputShutdown() {
        this.m_log.warn("Not implemented!!!");
        throw new NotYetImplementedException();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.m_out.write(data);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.m_socketSessionConfig.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.m_socketSessionConfig.setOobInline(on);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.m_log.warn("Not implemented!!!");
        throw new NotYetImplementedException();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.m_socketSessionConfig.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.m_socketSessionConfig.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.m_socketSessionConfig.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.m_socketSessionConfig.setSoLinger(linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.m_socketSessionConfig.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.m_socketSessionConfig.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.m_log.debug("Closing input stream from: " + ThreadUtils.dumpStack());
        this.m_in.close();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.m_log.debug("Closing output stream from: " + ThreadUtils.dumpStack());
        this.m_out.close();
    }
}

