/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.UnsupportedEncodingException;
import org.littleshoot.mina.common.ByteBuffer;

public class MinaCodecUtils {
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    public static final byte AMP = 38;
    public static final byte COLON = 58;
    public static final byte CR = 13;
    public static final byte EQUALS = 61;
    public static final byte LF = 10;
    public static final byte SPACE = 32;
    public static final byte PLUS = 43;
    public static final byte QS = 63;
    public static final byte HT = 9;
    public static final byte PERCENT = 37;
    public static final byte FOWARD_SLASH = 47;
    public static final byte BACK_SLASH = 92;
    public static final byte QUOTE = 34;
    public static final byte SEMI_COLON = 59;
    public static final byte COMMA = 44;
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private static final String US_ASCII_CHARSET_NAME = "US-ASCII";
    private static boolean[] HTTP_SEPARATORS = new boolean[128];
    private static boolean[] HTTP_CONTROLS = new boolean[128];
    private static final int[] HEX_DEC = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public static boolean isHex(byte b) {
        return HEX_DEC[b] != -1;
    }

    public static boolean isHttpSeparator(byte b) {
        return HTTP_SEPARATORS[b];
    }

    public static boolean isHttpControl(byte b) {
        return HTTP_CONTROLS[b];
    }

    public static boolean isWhiteSpace(byte b) {
        return b == 32 || b == 9;
    }

    public static void pushBack(ByteBuffer buffer) {
        buffer.position(buffer.position() - 1);
    }

    public static int hexAsciiToDecimal(byte b) {
        return HEX_DEC[b];
    }

    public static byte[] getAsciiBytes(String str) {
        try {
            return str.getBytes(US_ASCII_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Required charset: US-ASCII");
        }
    }

    public static void appendString(ByteBuffer buffer, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            int b = string.charAt(i);
            if (MinaCodecUtils.isHttpControl((byte)b) && b != 9) {
                b = 32;
            }
            buffer.put((byte)b);
        }
    }

    public static void appendCRLF(ByteBuffer buffer) {
        buffer.put(CRLF_BYTES);
    }

    static {
        MinaCodecUtils.HTTP_SEPARATORS[34] = true;
        MinaCodecUtils.HTTP_SEPARATORS[40] = true;
        MinaCodecUtils.HTTP_SEPARATORS[41] = true;
        MinaCodecUtils.HTTP_SEPARATORS[44] = true;
        MinaCodecUtils.HTTP_SEPARATORS[47] = true;
        MinaCodecUtils.HTTP_SEPARATORS[58] = true;
        MinaCodecUtils.HTTP_SEPARATORS[59] = true;
        MinaCodecUtils.HTTP_SEPARATORS[60] = true;
        MinaCodecUtils.HTTP_SEPARATORS[61] = true;
        MinaCodecUtils.HTTP_SEPARATORS[62] = true;
        MinaCodecUtils.HTTP_SEPARATORS[63] = true;
        MinaCodecUtils.HTTP_SEPARATORS[64] = true;
        MinaCodecUtils.HTTP_SEPARATORS[91] = true;
        MinaCodecUtils.HTTP_SEPARATORS[93] = true;
        MinaCodecUtils.HTTP_SEPARATORS[92] = true;
        MinaCodecUtils.HTTP_SEPARATORS[123] = true;
        MinaCodecUtils.HTTP_SEPARATORS[125] = true;
        for (int i = 0; i <= 31; ++i) {
            MinaCodecUtils.HTTP_CONTROLS[i] = true;
        }
        MinaCodecUtils.HTTP_CONTROLS[127] = true;
    }
}

