/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.DefaultIoFilterChainBuilder;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.mina.filter.codec.ProtocolCodecFilter;
import org.littleshoot.mina.filter.executor.ExecutorFilter;
import org.littleshoot.mina.transport.socket.nio.SocketAcceptor;
import org.littleshoot.mina.transport.socket.nio.SocketAcceptorConfig;
import org.littleshoot.util.DaemonThreadFactory;
import org.littleshoot.util.NetworkUtils;
import org.littleshoot.util.mina.MinaServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaTcpServer
implements MinaServer {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final SocketAcceptor m_acceptor;
    private final IoHandler m_handler;

    public MinaTcpServer(ProtocolCodecFactory codecFactory, IoServiceListener ioServiceListener, IoHandler handler) {
        this(codecFactory, ioServiceListener, handler, "MINA-Server-Thread");
    }

    public MinaTcpServer(ProtocolCodecFactory codecFactory, IoServiceListener ioServiceListener, IoHandler handler, String baseThreadName) {
        if (ioServiceListener == null) {
            this.m_log.error("No IO Service Listener");
            throw new NullPointerException("Null listener");
        }
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        this.m_handler = handler;
        ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory(baseThreadName + "-Mina-TCP-Server"));
        this.m_acceptor = new SocketAcceptor(4, (Executor)executor);
        SocketAcceptorConfig cfg = this.m_acceptor.getDefaultConfig();
        cfg.setThreadModel(ThreadModel.MANUAL);
        cfg.setDisconnectOnUnbind(true);
        cfg.setReuseAddress(true);
        cfg.getSessionConfig().setReuseAddress(true);
        this.m_acceptor.addListener(ioServiceListener);
        DefaultIoFilterChainBuilder filterChainBuilder = cfg.getFilterChain();
        ProtocolCodecFilter codecFilter = new ProtocolCodecFilter(codecFactory);
        filterChainBuilder.addLast("codec", (IoFilter)codecFilter);
        filterChainBuilder.addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)executor));
        this.m_log.debug("Started MINA TCP server.");
    }

    @Override
    public void start(int port) throws IOException {
        InetSocketAddress address = new InetSocketAddress(NetworkUtils.getLocalHost(), port);
        this.m_acceptor.bind((SocketAddress)address, this.m_handler);
    }

    @Override
    public void stop() {
        this.m_acceptor.unbindAll();
    }

    @Override
    public void addIoServiceListener(IoServiceListener serviceListener) {
        if (serviceListener == null) {
            throw new NullPointerException("Null listener");
        }
        this.m_acceptor.addListener(serviceListener);
    }
}

