/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Collection;
import java.util.LinkedList;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MinaUtils.class);
    private static final CharsetDecoder DECODER = Charset.forName("US-ASCII").newDecoder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toAsciiString(ByteBuffer buf) {
        DECODER.reset();
        int position = buf.position();
        int limit = buf.limit();
        try {
            String string = buf.getString(DECODER);
            return string;
        }
        catch (CharacterCodingException e) {
            LOG.error("Could not decode: " + buf, (Throwable)e);
            String string = "";
            return string;
        }
        finally {
            buf.position(position);
            buf.limit(limit);
        }
    }

    public static String getString(ByteBuffer buf) {
        DECODER.reset();
        try {
            return buf.getString(DECODER);
        }
        catch (CharacterCodingException e) {
            LOG.error("Could not decode: " + buf, (Throwable)e);
            return "";
        }
    }

    public static byte[] toByteArray(ByteBuffer buf) {
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        return bytes;
    }

    public static Collection<ByteBuffer> split(ByteBuffer buffer, int chunkSize) {
        LinkedList<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
        int originalLimit = buffer.limit();
        int totalSent = 0;
        while (totalSent + chunkSize < originalLimit) {
            buffer.limit(totalSent + chunkSize);
            buffers.add(MinaUtils.createBuffer(buffer));
            totalSent += chunkSize;
        }
        buffer.limit(originalLimit);
        buffers.add(MinaUtils.createBuffer(buffer));
        return buffers;
    }

    private static ByteBuffer createBuffer(ByteBuffer buffer) {
        ByteBuffer data = ByteBuffer.allocate((int)(buffer.limit() - buffer.position()));
        data.put(buffer);
        data.flip();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<byte[]> splitToByteArrays(ByteBuffer buffer, int chunkSize) {
        LinkedList<byte[]> buffers = new LinkedList<byte[]>();
        int originalLimit = buffer.limit();
        int originalPosition = buffer.position();
        try {
            int totalSent = 0;
            while (totalSent + chunkSize < originalLimit) {
                buffer.limit(totalSent + chunkSize);
                buffers.add(MinaUtils.toByteArray(buffer));
                totalSent += chunkSize;
            }
            buffer.limit(originalLimit);
            buffers.add(MinaUtils.toByteArray(buffer));
        }
        finally {
            buffer.position(originalPosition);
            buffer.limit(originalLimit);
        }
        return buffers;
    }

    public static void putUnsignedByte(ByteBuffer bb, int value) {
        bb.put((byte)(value & 0xFF));
    }

    public static void putUnsignedByte(ByteBuffer bb, int position, int value) {
        bb.put(position, (byte)(value & 0xFF));
    }

    public static void putUnsignedShort(ByteBuffer bb, int value) {
        bb.putShort((short)(value & 0xFFFF));
    }

    public static void putUnsignedShort(ByteBuffer bb, int position, int value) {
        bb.putShort(position, (short)(value & 0xFFFF));
    }

    public static void putUnsignedInt(ByteBuffer bb, long value) {
        bb.putInt((int)(value & 0xFFFFFFFFL));
    }

    public static void putUnsignedInt(ByteBuffer bb, int position, long value) {
        bb.putInt(position, (int)(value & 0xFFFFFFFFL));
    }

    public static ByteBuffer toBuf(String str) {
        try {
            byte[] bytes = str.getBytes("US-ASCII");
            return ByteBuffer.wrap((byte[])bytes);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Bad encoding?", (Throwable)e);
            return ByteBuffer.allocate((int)0);
        }
    }

    public static boolean isUdp(IoSession session) {
        return session.getTransportType().isConnectionless();
    }
}

