/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;

public abstract class SkippingState
implements DecodingState {
    private final byte m_byteToSkip;

    public SkippingState(byte byteToSkip) {
        this.m_byteToSkip = byteToSkip;
    }

    @Override
    public DecodingState decode(ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        int beginPos = in.position();
        int limit = in.limit();
        for (int i = beginPos; i < limit; ++i) {
            byte b = in.get(i);
            if (b == this.m_byteToSkip) continue;
            in.position(i);
            return this.finishDecode();
        }
        in.position(limit);
        return this;
    }

    protected abstract DecodingState finishDecode() throws Exception;
}

