/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.util.mina.ByteBufferIoSessionOutputStream;
import org.littleshoot.util.mina.IoSessionInputStream;
import org.littleshoot.util.mina.IoSessionOutputStreamFactory;
import org.littleshoot.util.mina.IoSessionSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIoHandler
extends IoHandlerAdapter {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String KEY_IN = SocketIoHandler.class.getName() + ".in";
    private static final String KEY_OUT = SocketIoHandler.class.getName() + ".out";
    private int m_readTimeout;
    private int m_writeTimeout;
    private final IoSessionOutputStreamFactory m_osFactory;

    public SocketIoHandler() {
        this.m_osFactory = new IoSessionOutputStreamFactory(){

            @Override
            public ByteBufferIoSessionOutputStream newStream(IoSession session) {
                return new ByteBufferIoSessionOutputStream(session);
            }
        };
    }

    public SocketIoHandler(IoSessionOutputStreamFactory osFactory) {
        this.m_osFactory = osFactory;
    }

    public int getReadTimeout() {
        return this.m_readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.m_readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.m_writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.m_writeTimeout = writeTimeout;
    }

    public void sessionOpened(IoSession session) {
        session.setWriteTimeout(this.m_writeTimeout);
        session.setIdleTime(IdleStatus.READER_IDLE, this.m_readTimeout);
        IoSessionInputStream in = new IoSessionInputStream(session, this.m_readTimeout);
        OutputStream out = this.m_osFactory.newStream(session);
        session.setAttribute(KEY_IN, (Object)in);
        session.setAttribute(KEY_OUT, (Object)out);
        IoSessionSocket ioSocket = new IoSessionSocket(session, in, out);
        session.setAttribute("SOCKET", (Object)ioSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionClosed(IoSession session) throws Exception {
        this.m_log.debug("Closing streams!!!");
        InputStream in = (InputStream)session.getAttribute(KEY_IN);
        OutputStream out = (OutputStream)session.getAttribute(KEY_OUT);
        try {
            in.close();
        }
        finally {
            out.close();
        }
    }

    public void messageReceived(IoSession session, Object buf) {
        IoSessionInputStream in = (IoSessionInputStream)session.getAttribute(KEY_IN);
        in.write((ByteBuffer)buf);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.m_log.warn("Exception caught!!!", cause);
        IoSessionInputStream in = (IoSessionInputStream)session.getAttribute(KEY_IN);
        IOException e = null;
        if (cause instanceof StreamIoException) {
            e = (IOException)cause.getCause();
        } else if (cause instanceof IOException) {
            e = (IOException)cause;
        }
        if (e != null && in != null) {
            in.throwException(e);
        } else {
            this.m_log.warn("Unexpected exception.", cause);
            session.close();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.m_log.debug("Session Idle!!!");
        if (status == IdleStatus.READER_IDLE) {
            throw new StreamIoException(new SocketTimeoutException("Read timeout"));
        }
    }

    private static class StreamIoException
    extends RuntimeException {
        private static final long serialVersionUID = 3976736960742503222L;

        private StreamIoException(IOException cause) {
            super(cause);
        }
    }
}

