/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.util.mina;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolDecoder;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineProtocolDecoder
implements ProtocolDecoder {
    private final Logger LOG = LoggerFactory.getLogger(StateMachineProtocolDecoder.class);
    private final DecodingStateMachine m_stateMachine;
    private DecodingState m_currentState;

    public StateMachineProtocolDecoder(DecodingStateMachine stateMachine) {
        if (stateMachine == null) {
            throw new NullPointerException("stateMachine");
        }
        this.m_stateMachine = stateMachine;
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        DecodingState state = this.m_currentState;
        try {
            while (in.hasRemaining()) {
                int remaining;
                if (state == null) {
                    state = this.m_stateMachine.init();
                }
                if ((remaining = in.remaining()) == 0) {
                    this.LOG.debug("Breaking -- no remaining bytes...");
                } else {
                    DecodingState oldState = state;
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("Calling decode on state: {}", (Object)state.getClass().getSimpleName());
                    }
                    if ((state = state.decode(in, out)) == null) {
                        this.LOG.debug("Got null state...");
                        if (in.hasRemaining()) {
                            this.LOG.debug("State machine ended but hasn't read all data!!");
                            continue;
                        }
                    } else {
                        if (in.remaining() != remaining || oldState != state) continue;
                        this.LOG.debug("Nothing consumed...breaking");
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            state = null;
            throw e;
        }
        finally {
            this.m_currentState = state;
        }
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        this.LOG.debug("Finish decode called in top-level state machine protocol decoder");
    }
}

