/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.p2p;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.lastbamboo.common.p2p.CallState;
import org.lastbamboo.common.p2p.RawUdpServerDepot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRawUdpServerDepot
implements RawUdpServerDepot {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, CallState> sessions = new ConcurrentHashMap<String, CallState>();
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public DefaultRawUdpServerDepot() {
        this.startPurging();
        this.startServerThreaded();
    }

    private void startServerThreaded() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
            }
        };
        Thread t = new Thread(runner, "Incoming-Raw-UDP-Server-Thread");
        t.setDaemon(true);
        t.start();
    }

    private void startPurging() {
        Timer t = new Timer();
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                Map map = DefaultRawUdpServerDepot.this.sessions;
                synchronized (map) {
                    for (Map.Entry e : DefaultRawUdpServerDepot.this.sessions.entrySet()) {
                        CallState ts = (CallState)e.getValue();
                        if (now - ts.getTime() < 30000L) {
                            DefaultRawUdpServerDepot.this.log.info("Not purging new socket");
                            return;
                        }
                        Socket sock = ts.getSocket();
                        if (sock == null || sock.isConnected()) continue;
                        DefaultRawUdpServerDepot.this.log.info("Removing unconnected socket!");
                        IOUtils.closeQuietly((Socket)sock);
                        DefaultRawUdpServerDepot.this.sessions.remove(e.getKey());
                    }
                }
            }
        };
        t.schedule(task, 30000L, 30000L);
    }

    public void onSocket(String id, Socket sock) throws IOException {
        this.addSocket(id, sock);
    }

    @Override
    public void addSocket(String id, Socket sock) {
        this.log.info("Adding socket with ID: " + id + "to: " + this.hashCode());
        try {
            sock.setSoTimeout(50000);
        }
        catch (SocketException e) {
            this.log.warn("Error setting SO TIMEOUT?", (Throwable)e);
        }
        this.sessions.put(id, new TimestampedSocket(sock));
    }

    @Override
    public Socket getSocket(String id) {
        CallState ts = this.sessions.get(id);
        if (ts == null) {
            return null;
        }
        return ts.getSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getIds() {
        Map<String, CallState> map = this.sessions;
        synchronized (map) {
            return this.sessions.keySet();
        }
    }

    @Override
    public void addError(String id, String msg) {
        this.log.info("Adding error for " + id + " with msg: " + msg);
        this.sessions.put(id, new CallError(msg));
    }

    @Override
    public long write(String id, InputStream is, long contentLength) throws IOException {
        Socket sock = this.getSocket(id);
        if (sock != null) {
            this.log.info("Writing from socket: {}", (Object)sock.getLocalSocketAddress());
            this.log.info("Writing to socket output stream!");
            OutputStream os = sock.getOutputStream();
            return this.copy(is, os, contentLength);
        }
        this.log.warn("Could not find socket with ID {} in " + this.sessions, (Object)id);
        return -1L;
    }

    @Override
    public void write(String id, byte[] data) throws IOException {
        Socket sock = this.getSocket(id);
        if (sock != null) {
            this.log.info("Writing from socket: {}", (Object)sock.getLocalSocketAddress());
            this.log.info("Writing to socket output stream!");
            OutputStream os = sock.getOutputStream();
            os.write(data);
        } else {
            this.log.warn("Could not find socket with ID {} in " + this.sessions, (Object)id);
        }
    }

    private void threadedCopy(final InputStream is, final OutputStream os, String threadName, final int contentLength) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultRawUdpServerDepot.this.copy(is, os, contentLength);
                }
                catch (IOException e) {
                    DefaultRawUdpServerDepot.this.log.info("Exception on copy. Hung up?", (Throwable)e);
                }
            }
        };
        Thread t = new Thread(runner, threadName);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public long read(String id, OutputStream outputStream, int length) throws IOException {
        this.log.info("Reading data...");
        Socket sock = this.getSocket(id);
        if (sock == null) {
            this.log.warn("Call " + id + " not found from " + this.hashCode() + " in {}", this.sessions);
            return -1L;
        }
        this.log.info("Got socket -- remote host: {}", (Object)sock.getRemoteSocketAddress());
        InputStream is = sock.getInputStream();
        byte[] data = new byte[length];
        int read = is.read(data);
        outputStream.write(data, 0, read);
        return read;
    }

    private long copy(InputStream in, OutputStream out, long originalByteCount) throws IOException {
        byte[] buffer = new byte[4096];
        int len = 0;
        long written = 0L;
        try {
            for (long byteCount = originalByteCount; byteCount > 0L; byteCount -= (long)len) {
                len = byteCount < 4096L ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, 4096);
                this.log.debug("Read {} bytes", (Object)len);
                if (len == -1) {
                    this.log.debug("Breaking on length = -1");
                    break;
                }
                this.log.info("Total written: " + written);
                out.write(buffer, 0, len);
                this.log.debug("Now written: " + (written += (long)len));
            }
            long l = written;
            return l;
        }
        catch (IOException e) {
            this.log.debug("Got IOException during copy after writing " + written + " of " + originalByteCount, (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            this.log.debug("Runtime error after writing " + written + " of " + originalByteCount, (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        finally {
            out.flush();
        }
    }

    @Override
    public JSONObject toJson() {
        this.log.info("Accessing JSON for sessions: {}", this.sessions);
        JSONObject json = new JSONObject();
        JSONArray calls = new JSONArray();
        for (Map.Entry<String, CallState> entry : this.sessions.entrySet()) {
            JSONObject jsonId = new JSONObject();
            String id = entry.getKey();
            CallState cs = entry.getValue();
            jsonId.put((Object)"id", (Object)id);
            jsonId.put((Object)"state", (Object)cs.getMessage());
            calls.add((Object)jsonId);
        }
        json.put((Object)"calls", (Object)calls);
        return json;
    }

    public void reconnected() {
    }

    private static final class TimestampedSocket
    implements CallState {
        private final long time = System.currentTimeMillis();
        private final Socket sock;

        public TimestampedSocket(Socket sock) {
            this.sock = sock;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public Socket getSocket() {
            return this.sock;
        }

        @Override
        public String getMessage() {
            return "CONNECTED";
        }
    }

    private static final class CallError
    implements CallState {
        private final long time = System.currentTimeMillis();
        private final String msg;

        public CallError(String msg) {
            this.msg = msg;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public Socket getSocket() {
            return null;
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }
}

