/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.p2p;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.commons.io.IOUtils;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.offer.answer.NoAnswerException;
import org.lastbamboo.common.offer.answer.OfferAnswer;
import org.lastbamboo.common.offer.answer.OfferAnswerConnectException;
import org.lastbamboo.common.offer.answer.OfferAnswerFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerListener;
import org.lastbamboo.common.offer.answer.OfferAnswerMessage;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.offer.answer.Offerer;
import org.lastbamboo.common.p2p.TcpUdpSocket;
import org.littleshoot.util.CommonUtils;
import org.littleshoot.util.KeyStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTcpUdpSocket
implements TcpUdpSocket<Socket>,
OfferAnswerTransactionListener,
OfferAnswerListener<Socket>,
KeyStorage {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final long startTime = System.currentTimeMillis();
    private final Object socketLock = new Object();
    private final Object answerLock = new Object();
    private volatile boolean gotAnswer;
    private final AtomicReference<Socket> socketRef = new AtomicReference();
    private volatile boolean finishedWaitingForSocket = false;
    private final Offerer offerer;
    private final OfferAnswer offerAnswer;
    private final int relayWaitTime;
    private final long offerTimeoutTime;
    private final byte[] writeKey = CommonUtils.generateKey();
    private byte[] readKey = null;
    private static final ExecutorService processingThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        private int count = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, DefaultTcpUdpSocket.class.getSimpleName() + "-" + this.count++);
            t.setDaemon(true);
            return t;
        }
    });
    private final IceMediaStreamDesc desc;

    public DefaultTcpUdpSocket(Offerer offerer, OfferAnswerFactory<Socket> offerAnswerFactory, int relayWaitTime, IceMediaStreamDesc desc) throws IOException {
        this(offerer, offerAnswerFactory, relayWaitTime, 30000L, desc);
    }

    public DefaultTcpUdpSocket(Offerer offerer, OfferAnswerFactory<Socket> offerAnswerFactory, int relayWaitTime, long offerTimeoutTime, IceMediaStreamDesc desc) throws IOException {
        this.offerer = offerer;
        this.relayWaitTime = relayWaitTime;
        this.offerTimeoutTime = offerTimeoutTime;
        this.desc = desc;
        try {
            this.offerAnswer = offerAnswerFactory.createOfferer((OfferAnswerListener)this, desc);
        }
        catch (OfferAnswerConnectException e) {
            throw new IOExceptionWithCause("Could not create offerer", (Throwable)e);
        }
    }

    @Override
    public Socket newSocket(final URI uri) throws IOException, NoAnswerException {
        final byte[] offer = this.offerAnswer.generateOffer();
        processingThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultTcpUdpSocket.this.offerer.offer(uri, offer, (OfferAnswerTransactionListener)DefaultTcpUdpSocket.this, (KeyStorage)DefaultTcpUdpSocket.this);
                }
                catch (IOException e) {
                    DefaultTcpUdpSocket.this.log.warn("Error sending offer", (Throwable)e);
                    DefaultTcpUdpSocket.this.notifySocketLock();
                }
            }
        });
        return this.waitForSocket(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket waitForSocket(URI sipUri) throws IOException, NoAnswerException {
        this.log.info("Waiting for socket -- sent offer.");
        Object object = this.answerLock;
        synchronized (object) {
            if (!this.gotAnswer) {
                this.log.info("Waiting for answer for " + this.offerTimeoutTime);
                try {
                    this.answerLock.wait(this.offerTimeoutTime);
                }
                catch (InterruptedException e) {
                    this.log.error("Interrupted?", (Throwable)e);
                }
            }
        }
        if (!this.gotAnswer) {
            String msg = "Did not get an answer from " + sipUri + " after waiting " + this.offerTimeoutTime + "- Could have detected failure earlier too.";
            this.log.info(msg);
            throw new NoAnswerException(msg);
        }
        this.log.info("Got answer...");
        object = this.socketLock;
        synchronized (object) {
            this.log.info("Got socket lock...");
            if (!this.finishedWaitingForSocket) {
                this.log.trace("Waiting for socket...");
                try {
                    this.socketLock.wait(this.relayWaitTime * 1000 + 1);
                }
                catch (InterruptedException e) {
                    this.log.error("Unexpectedly interrupted", (Throwable)e);
                }
            }
            if (this.socketRef.get() == null && this.desc.isUseRelay()) {
                this.log.info("Could not create direct connection - using relay!");
                this.offerAnswer.useRelay();
                this.log.trace("Waiting for socket...");
                try {
                    this.socketLock.wait(35000L);
                }
                catch (InterruptedException e) {
                    this.log.error("Unexpectedly interrupted", (Throwable)e);
                }
            }
        }
        if (this.socketRef.get() == null) {
            this.log.warn("Socket is null...");
            this.offerAnswer.close();
            throw new IOException("Could not connect to remote host: " + sipUri);
        }
        this.log.trace("Returning socket!!");
        return this.socketRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySocketLock() {
        this.log.info("Notifying socket lock");
        Object object = this.socketLock;
        synchronized (object) {
            this.log.info("Got socket lock...notifying...");
            this.finishedWaitingForSocket = true;
            this.socketLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransactionSucceeded(final OfferAnswerMessage response) {
        this.log.info("Received INVITE OK");
        this.log.debug("Successful transaction after {} milliseconds...", (Object)this.getElapsedTime());
        Object object = this.answerLock;
        synchronized (object) {
            this.gotAnswer = true;
            this.answerLock.notifyAll();
        }
        processingThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                DefaultTcpUdpSocket.this.offerAnswer.processAnswer(response.getBody());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransactionFailed(OfferAnswerMessage response) {
        this.log.warn("Failed transaction after " + this.getElapsedTime() + " milliseconds...");
        Object object = this.answerLock;
        synchronized (object) {
            this.answerLock.notify();
        }
        this.offerAnswer.close();
    }

    public void onTcpSocket(Socket sock) {
        this.log.info("Got a TCP socket!");
        if (this.processedSocket(sock)) {
            this.offerAnswer.closeUdp();
        } else {
            this.offerAnswer.closeTcp();
        }
    }

    public void onUdpSocket(Socket sock) {
        if (this.processedSocket(sock)) {
            this.offerAnswer.closeTcp();
        } else {
            this.offerAnswer.closeUdp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processedSocket(Socket sock) {
        this.log.info("Processing socket");
        AtomicReference<Socket> atomicReference = this.socketRef;
        synchronized (atomicReference) {
            if (this.socketRef.get() != null) {
                this.log.info("Ignoring socket");
                IOUtils.closeQuietly((Socket)sock);
                return false;
            }
            this.socketRef.set(sock);
        }
        this.log.info("Notifying socket lock!!");
        this.notifySocketLock();
        return true;
    }

    public void onOfferAnswerFailed(OfferAnswer offerAnswer) {
        this.notifySocketLock();
        this.offerAnswer.close();
    }

    private long getElapsedTime() {
        long now = System.currentTimeMillis();
        long elapsedTime = now - this.startTime;
        return elapsedTime;
    }

    public byte[] getWriteKey() {
        return this.writeKey;
    }

    public byte[] getReadKey() {
        return this.readKey;
    }

    public void setReadKey(byte[] key) {
        this.readKey = key;
    }
}

