/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.p2p;

import java.net.InetSocketAddress;
import java.net.Socket;
import org.lastbamboo.common.p2p.PortMappingState;
import org.lastbamboo.common.p2p.SocketType;

public class P2PConnectionEvent {
    private final String jid;
    private final boolean incoming;
    private final InetSocketAddress remoteSocketAddress;
    private final boolean connected;
    private final Socket sock;
    private final SocketType socketType;
    private final PortMappingState mapping;

    public P2PConnectionEvent(String jid, Socket sock, boolean incoming, boolean connected, PortMappingState mapping, SocketType socketType) {
        this.jid = jid;
        this.sock = sock;
        this.mapping = mapping;
        this.socketType = socketType;
        this.remoteSocketAddress = (InetSocketAddress)sock.getRemoteSocketAddress();
        this.incoming = incoming;
        this.connected = connected;
    }

    public String getJid() {
        return this.jid;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public Socket getSocket() {
        return this.sock;
    }

    public String toString() {
        return "P2PConnectionEvent [jid=" + this.jid + ", incoming=" + this.incoming + ", remoteSocketAddress=" + this.remoteSocketAddress + ", connected=" + this.connected + "]";
    }

    public SocketType getSocketType() {
        return this.socketType;
    }

    public PortMappingState getMapping() {
        return this.mapping;
    }
}

