/*****************************************************************************
* Product of NIST/ITL Advanced Networking Technologies Division (ANTD).      * 
******************************************************************************/
package org.lastbamboo.common.sdp.fields;

/**
*Field names for SDP Fields.
*
*@version  JAIN-SIP-1.1
*
*@author M. Ranganathan <mranga@nist.gov>  <br/>
*
*<a href="{@docRoot}/uncopyright.html">This code is in the public domain.</a>
*
*/

public interface SDPFieldNames {

	public static final String SESSION_NAME_FIELD = "s=";
	public static final String INFORMATION_FIELD = "i=";
	public static final String EMAIL_FIELD = "e=";
	public static final String PHONE_FIELD = "p=";
	public static final String CONNECTION_FIELD = "c=";
	public static final String BANDWIDTH_FIELD = "b=";
	public static final String ORIGIN_FIELD = "o=";
	public static final String TIME_FIELD = "t=";
	public static final String KEY_FIELD = "k=";
	public static final String ATTRIBUTE_FIELD = "a=";
	public static final String PROTO_VERSION_FIELD = "v=";
	public static final String URI_FIELD = "u=";
	public static final String MEDIA_FIELD = "m=";
	public static final String REPEAT_FIELD = "r=";
	public static final String ZONE_FIELD = "z=";
}
/*
 * $Log: SDPFieldNames.java,v $
 * Revision 1.2  2004/01/22 13:26:27  sverker
 * Issue number:
 * Obtained from:
 * Submitted by:  sverker
 * Reviewed by:   mranga
 *
 * Major reformat of code to conform with style guide. Resolved compiler and javadoc warnings. Added CVS tags.
 *
 * CVS: ----------------------------------------------------------------------
 * CVS: Issue number:
 * CVS:   If this change addresses one or more issues,
 * CVS:   then enter the issue number(s) here.
 * CVS: Obtained from:
 * CVS:   If this change has been taken from another system,
 * CVS:   then name the system in this line, otherwise delete it.
 * CVS: Submitted by:
 * CVS:   If this code has been contributed to the project by someone else; i.e.,
 * CVS:   they sent us a patch or a set of diffs, then include their name/email
 * CVS:   address here. If this is your work then delete this line.
 * CVS: Reviewed by:
 * CVS:   If we are doing pre-commit code reviews and someone else has
 * CVS:   reviewed your changes, include their name(s) here.
 * CVS:   If you have not had it reviewed then delete this line.
 *
 */
