/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp;

import java.text.ParseException;
import org.lastbamboo.common.sdp.Host;
import org.lastbamboo.common.sdp.HostPort;
import org.lastbamboo.common.sdp.LexerCore;
import org.lastbamboo.common.sdp.ParserCore;

public class HostNameParser
extends ParserCore {
    public HostNameParser(String hname) {
        this.lexer = new LexerCore("charLexer", hname);
    }

    public HostNameParser(LexerCore lexer) {
        this.lexer = lexer;
        lexer.selectLexer("charLexer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String domainLabel() throws ParseException {
        StringBuffer retval = new StringBuffer();
        while (this.lexer.hasMoreChars()) {
            char la = this.lexer.lookAhead(0);
            if (LexerCore.isAlpha(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (LexerCore.isDigit(la)) {
                this.lexer.consume(1);
                retval.append(la);
                continue;
            }
            if (la != '-') break;
            this.lexer.consume(1);
            retval.append(la);
        }
        String string = retval.toString();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String ipv6Reference() throws ParseException {
        char la;
        StringBuffer retval;
        block5: {
            retval = new StringBuffer();
            while (this.lexer.hasMoreChars()) {
                la = this.lexer.lookAhead(0);
                if (LexerCore.isHexDigit(la)) {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                if (la == '.' || la == ':' || la == '[') {
                    this.lexer.consume(1);
                    retval.append(la);
                    continue;
                }
                break block5;
            }
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        if (la != ']') throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        this.lexer.consume(1);
        retval.append(la);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Host host() throws ParseException {
        StringBuffer hname = new StringBuffer();
        if (this.lexer.lookAhead(0) == '[') {
            hname.append(this.ipv6Reference());
        } else {
            String nextTok = this.domainLabel();
            hname.append(nextTok);
            while (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == '.') {
                this.lexer.consume(1);
                nextTok = this.domainLabel();
                hname.append(".");
                hname.append(nextTok);
            }
        }
        String hostname = hname.toString();
        if (hostname.equals("")) {
            throw new ParseException(this.lexer.getBuffer() + ": Illegal Host name ", this.lexer.getPtr());
        }
        Host host = new Host(hostname);
        return host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostPort hostPort() throws ParseException {
        Host host = this.host();
        HostPort hp = new HostPort();
        hp.setHost(host);
        this.lexer.SPorHT();
        if (this.lexer.hasMoreChars() && this.lexer.lookAhead(0) == ':') {
            this.lexer.consume(1);
            this.lexer.SPorHT();
            try {
                String port = this.lexer.number();
                hp.setPort(Integer.parseInt(port));
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(this.lexer.getBuffer() + " :Error parsing port ", this.lexer.getPtr());
            }
        }
        HostPort hostPort = hp;
        return hostPort;
    }

    public static void main(String[] args) throws ParseException {
        String[] hostNames = new String[]{"foo.bar.com:1234", "proxima.chaplin.bt.co.uk", "129.6.55.181:2345", ":1234", "foo.bar.com:         1234", "foo.bar.com     :      1234   "};
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                HostNameParser hnp = new HostNameParser(hostNames[i]);
                HostPort hp = hnp.hostPort();
                System.out.println("[" + hp.encode() + "]");
                continue;
            }
            catch (ParseException ex) {
                System.out.println("exception text = " + ex.getMessage());
            }
        }
    }
}

