/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.lastbamboo.common.sdp.GenericObject;
import org.lastbamboo.common.sdp.Host;

public final class HostPort
extends GenericObject {
    protected Host host = null;
    protected int port = -1;

    @Override
    public String encode() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.host.encode());
        if (this.port != -1) {
            retval.append(":").append(this.port);
        }
        return retval.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        HostPort that = (HostPort)other;
        return this.port == that.port && this.host.equals(that.host);
    }

    public Host getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public void removePort() {
        this.port = -1;
    }

    public void setHost(Host h) {
        this.host = h;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.host == null) {
            return null;
        }
        return this.host.getInetAddress();
    }

    @Override
    public void merge(Object mergeObject) {
        super.merge(mergeObject);
        if (this.port == -1) {
            this.port = ((HostPort)mergeObject).port;
        }
    }

    @Override
    public Object clone() {
        HostPort retval = (HostPort)super.clone();
        if (this.host != null) {
            retval.host = (Host)this.host.clone();
        }
        return retval;
    }

    public String toString() {
        return this.getClass().getName() + " for: " + this.host + ":" + this.port;
    }
}

