/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp;

import java.util.Vector;
import org.lastbamboo.common.sdp.NameValue;
import org.lastbamboo.common.sdp.api.Connection;
import org.lastbamboo.common.sdp.api.Info;
import org.lastbamboo.common.sdp.api.Key;
import org.lastbamboo.common.sdp.api.Media;
import org.lastbamboo.common.sdp.api.MediaDescription;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.AttributeField;
import org.lastbamboo.common.sdp.fields.BandwidthField;
import org.lastbamboo.common.sdp.fields.ConnectionField;
import org.lastbamboo.common.sdp.fields.InformationField;
import org.lastbamboo.common.sdp.fields.KeyField;
import org.lastbamboo.common.sdp.fields.MediaField;
import org.lastbamboo.common.sdp.fields.SDPField;

public class MediaDescriptionImpl
implements MediaDescription {
    protected MediaField mediaField;
    protected InformationField informationField;
    protected ConnectionField connectionField;
    protected Vector bandwidthFields = new Vector();
    protected KeyField keyField;
    protected Vector attributeFields = new Vector();

    public String encode() {
        int i;
        StringBuffer retval = new StringBuffer();
        if (this.mediaField != null) {
            retval.append(this.mediaField.encode());
        }
        if (this.informationField != null) {
            retval.append(this.informationField.encode());
        }
        if (this.connectionField != null) {
            retval.append(this.connectionField.encode());
        }
        if (this.bandwidthFields != null) {
            for (i = 0; i < this.bandwidthFields.size(); ++i) {
                BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
                retval.append(bandwidthField.encode());
            }
        }
        if (this.keyField != null) {
            retval.append(this.keyField.encode());
        }
        if (this.attributeFields != null) {
            for (i = 0; i < this.attributeFields.size(); ++i) {
                retval.append(((SDPField)this.attributeFields.elementAt(i)).encode());
            }
        }
        return retval.toString();
    }

    public String toString() {
        return this.encode();
    }

    public MediaField getMediaField() {
        return this.mediaField;
    }

    public InformationField getInformationField() {
        return this.informationField;
    }

    public ConnectionField getConnectionField() {
        return this.connectionField;
    }

    public KeyField getKeyField() {
        return this.keyField;
    }

    public Vector getAttributeFields() {
        return this.attributeFields;
    }

    public void setMediaField(MediaField m) {
        this.mediaField = m;
    }

    public void setInformationField(InformationField i) {
        this.informationField = i;
    }

    public void setConnectionField(ConnectionField c) {
        this.connectionField = c;
    }

    public void addBandwidthField(BandwidthField b) {
        this.bandwidthFields.add(b);
    }

    public void setKeyField(KeyField k) {
        this.keyField = k;
    }

    public void setAttributeFields(Vector a) {
        this.attributeFields = a;
    }

    @Override
    public Media getMedia() {
        return this.mediaField;
    }

    protected void addAttribute(AttributeField af) {
        this.attributeFields.add(af);
    }

    protected boolean hasAttribute(String name) {
        for (int i = 0; i < this.attributeFields.size(); ++i) {
            AttributeField af = (AttributeField)this.attributeFields.elementAt(i);
            if (!af.getAttribute().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setMedia(Media media) throws SdpException {
        if (media == null) {
            throw new SdpException("The media is null");
        }
        if (!(media instanceof MediaField)) {
            throw new SdpException("A mediaField parameter is required");
        }
        this.mediaField = (MediaField)media;
    }

    @Override
    public Info getInfo() {
        InformationField informationField = this.getInformationField();
        if (informationField == null) {
            return null;
        }
        return informationField;
    }

    @Override
    public void setInfo(Info i) throws SdpException {
        if (i == null) {
            throw new SdpException("The info is null");
        }
        if (!(i instanceof InformationField)) {
            throw new SdpException("A informationField parameter is required");
        }
        this.informationField = (InformationField)i;
    }

    @Override
    public Connection getConnection() {
        return this.connectionField;
    }

    @Override
    public void setConnection(Connection conn) throws SdpException {
        if (conn == null) {
            throw new SdpException("The conn is null");
        }
        if (!(conn instanceof ConnectionField)) {
            throw new SdpException("bad implementation");
        }
        this.connectionField = (ConnectionField)conn;
    }

    @Override
    public Vector getBandwidths(boolean create) {
        return this.bandwidthFields;
    }

    @Override
    public void setBandwidths(Vector bandwidths) throws SdpException {
        if (bandwidths == null) {
            throw new SdpException("The vector bandwidths is null");
        }
        this.bandwidthFields = bandwidths;
    }

    @Override
    public int getBandwidth(String name) throws SdpParseException {
        if (name == null) {
            throw new NullPointerException("null parameter");
        }
        if (this.bandwidthFields == null) {
            return -1;
        }
        for (int i = 0; i < this.bandwidthFields.size(); ++i) {
            BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
            String type = bandwidthField.getBwtype();
            if (type == null || !type.equals(name)) continue;
            return bandwidthField.getBandwidth();
        }
        return -1;
    }

    @Override
    public void setBandwidth(String name, int value) throws SdpException {
        if (name == null) {
            throw new SdpException("The name is null");
        }
        for (int i = 0; i < this.bandwidthFields.size(); ++i) {
            BandwidthField bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i);
            String type = bandwidthField.getBwtype();
            if (type == null || !type.equals(name)) continue;
            bandwidthField.setBandwidth(value);
        }
    }

    @Override
    public void removeBandwidth(String name) {
        BandwidthField bandwidthField;
        String type;
        if (name == null) {
            throw new NullPointerException("null bandwidth type");
        }
        int i = 0;
        for (i = 0; !(i >= this.bandwidthFields.size() || (type = (bandwidthField = (BandwidthField)this.bandwidthFields.elementAt(i)).getBwtype()) != null && type.equals(name)); ++i) {
        }
        if (i < this.bandwidthFields.size()) {
            this.bandwidthFields.removeElementAt(i);
        }
    }

    @Override
    public Key getKey() {
        if (this.keyField == null) {
            return null;
        }
        return this.keyField;
    }

    @Override
    public void setKey(Key key) throws SdpException {
        if (key == null) {
            throw new SdpException("The key is null");
        }
        if (!(key instanceof KeyField)) {
            throw new SdpException("A keyField parameter is required");
        }
        KeyField keyField = (KeyField)key;
        this.setKeyField(keyField);
    }

    @Override
    public Vector getAttributes(boolean create) {
        return this.attributeFields;
    }

    @Override
    public void setAttributes(Vector attributes) throws SdpException {
        this.attributeFields = attributes;
    }

    @Override
    public String getAttribute(String name) throws SdpParseException {
        if (name != null) {
            for (int i = 0; i < this.attributeFields.size(); ++i) {
                AttributeField af = (AttributeField)this.attributeFields.elementAt(i);
                if (!name.equals(af.getAttribute().getName())) continue;
                return (String)af.getAttribute().getValue();
            }
            return null;
        }
        throw new NullPointerException("null arg!");
    }

    @Override
    public void setAttribute(String name, String value) throws SdpException {
        NameValue nv;
        AttributeField af;
        if (name == null) {
            throw new SdpException("The parameters are null");
        }
        int i = 0;
        for (i = 0; i < this.attributeFields.size(); ++i) {
            af = (AttributeField)this.attributeFields.elementAt(i);
            if (!af.getAttribute().getName().equals(name)) continue;
            nv = af.getAttribute();
            nv.setValue(value);
            break;
        }
        if (i == this.attributeFields.size()) {
            af = new AttributeField();
            nv = new NameValue(name, value);
            af.setAttribute(nv);
            this.attributeFields.add(af);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException("null arg!");
        }
        if (name != null) {
            AttributeField af;
            int i = 0;
            for (i = 0; i < this.attributeFields.size() && !(af = (AttributeField)this.attributeFields.elementAt(i)).getAttribute().getName().equals(name); ++i) {
            }
            if (i < this.attributeFields.size()) {
                this.attributeFields.removeElementAt(i);
            }
        }
    }

    @Override
    public Vector getMimeTypes() throws SdpException {
        MediaField mediaField = (MediaField)this.getMedia();
        String type = mediaField.getMediaType();
        String protocol = mediaField.getProtocol();
        Vector formats = mediaField.getMediaFormats(false);
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < formats.size(); ++i) {
            String result = null;
            if (protocol.equals("RTP/AVP")) {
                if (this.getAttribute("RTPMAP") != null) {
                    result = type + "/" + protocol;
                }
            } else {
                result = type + "/" + protocol;
            }
            v.addElement(result);
        }
        return v;
    }

    @Override
    public Vector getMimeParameters() throws SdpException {
        String rate = this.getAttribute("rate");
        String ptime = this.getAttribute("ptime");
        String maxptime = this.getAttribute("maxptime");
        String ftmp = this.getAttribute("ftmp");
        Vector<String> result = new Vector<String>();
        result.addElement(rate);
        result.addElement(ptime);
        result.addElement(maxptime);
        result.addElement(ftmp);
        return result;
    }

    @Override
    public void addDynamicPayloads(Vector payloadNames, Vector payloadValues) throws SdpException {
        MediaField mediaField = (MediaField)this.getMedia();
        if (payloadNames == null || payloadValues == null) {
            throw new SdpException(" The vectors are null");
        }
        if (payloadNames.isEmpty() || payloadValues.isEmpty()) {
            throw new SdpException(" The vectors are empty");
        }
        if (payloadNames.size() != payloadValues.size()) {
            throw new SdpException(" The vector sizes are unequal");
        }
        for (int i = 0; i < payloadNames.size(); ++i) {
            String name = (String)payloadNames.elementAt(i);
            String value = (String)payloadValues.elementAt(i);
            this.setAttribute(name, value);
        }
    }
}

