/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp;

import org.lastbamboo.common.sdp.GenericObject;
import org.lastbamboo.common.sdp.GenericObjectList;

public class NameValue
extends GenericObject {
    protected boolean isQuotedString;
    protected String separator;
    protected String quotes;
    protected String name;
    protected Object value;

    public NameValue() {
        this.name = null;
        this.value = null;
        this.separator = "=";
        this.quotes = "";
    }

    public NameValue(String n, Object v) {
        this.name = n;
        this.value = v;
        this.separator = "=";
        this.quotes = "";
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public void setQuotedValue() {
        this.isQuotedString = true;
        this.quotes = "\"";
    }

    public boolean isValueQuoted() {
        return this.isQuotedString;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setValue(Object v) {
        this.value = v;
    }

    @Override
    public String encode() {
        if (this.name != null && this.value != null) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject gv = (GenericObject)this.value;
                return this.name + this.separator + this.quotes + gv.encode() + this.quotes;
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList gvlist = (GenericObjectList)this.value;
                return this.name + this.separator + gvlist.encode();
            }
            return this.name + this.separator + this.quotes + this.value.toString() + this.quotes;
        }
        if (this.name == null && this.value != null) {
            if (GenericObject.isMySubclass(this.value.getClass())) {
                GenericObject gv = (GenericObject)this.value;
                return gv.encode();
            }
            if (GenericObjectList.isMySubclass(this.value.getClass())) {
                GenericObjectList gvlist = (GenericObjectList)this.value;
                return gvlist.encode();
            }
            return this.quotes + this.value.toString() + this.quotes;
        }
        if (this.name != null && this.value == null) {
            return this.name;
        }
        return "";
    }

    @Override
    public Object clone() {
        NameValue retval = (NameValue)super.clone();
        if (this.value != null) {
            retval.value = NameValue.makeClone(this.value);
        }
        return retval;
    }

    @Override
    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        NameValue that = (NameValue)other;
        if (this == that) {
            return true;
        }
        if (this.name == null && that.name != null || this.name != null && that.name == null) {
            return false;
        }
        if (this.name != null && that.name != null && this.name.compareToIgnoreCase(that.name) != 0) {
            return false;
        }
        if (this.value != null && that.value == null || this.value == null && that.value != null) {
            return false;
        }
        if (this.value == that.value) {
            return true;
        }
        if (this.value instanceof String) {
            if (this.isQuotedString) {
                return this.value.equals(that.value);
            }
            String val = (String)this.value;
            String val1 = (String)that.value;
            return val.compareToIgnoreCase(val1) == 0;
        }
        return this.value.equals(that.value);
    }
}

