/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Vector;
import org.lastbamboo.common.sdp.MediaDescriptionImpl;
import org.lastbamboo.common.sdp.TimeDescriptionImpl;
import org.lastbamboo.common.sdp.api.Connection;
import org.lastbamboo.common.sdp.api.Info;
import org.lastbamboo.common.sdp.api.Key;
import org.lastbamboo.common.sdp.api.Origin;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.api.SessionDescription;
import org.lastbamboo.common.sdp.api.SessionName;
import org.lastbamboo.common.sdp.api.URI;
import org.lastbamboo.common.sdp.api.Version;
import org.lastbamboo.common.sdp.fields.AttributeField;
import org.lastbamboo.common.sdp.fields.BandwidthField;
import org.lastbamboo.common.sdp.fields.ConnectionField;
import org.lastbamboo.common.sdp.fields.EmailField;
import org.lastbamboo.common.sdp.fields.InformationField;
import org.lastbamboo.common.sdp.fields.KeyField;
import org.lastbamboo.common.sdp.fields.MediaField;
import org.lastbamboo.common.sdp.fields.OriginField;
import org.lastbamboo.common.sdp.fields.PhoneField;
import org.lastbamboo.common.sdp.fields.ProtoVersionField;
import org.lastbamboo.common.sdp.fields.RepeatField;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.fields.SessionNameField;
import org.lastbamboo.common.sdp.fields.TimeField;
import org.lastbamboo.common.sdp.fields.URIField;
import org.lastbamboo.common.sdp.fields.ZoneField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDescriptionImpl
implements SessionDescription {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private TimeDescriptionImpl currentTimeDescription;
    private MediaDescriptionImpl currentMediaDescription;
    protected ProtoVersionField versionImpl;
    protected OriginField originImpl;
    protected SessionNameField sessionNameImpl;
    protected InformationField infoImpl;
    protected URIField uriImpl;
    protected ConnectionField connectionImpl;
    protected KeyField keyImpl;
    protected Vector timeDescriptions;
    protected Vector mediaDescriptions;
    protected Vector zoneAdjustments = new Vector();
    protected Vector emailList = new Vector();
    protected Vector phoneList = new Vector();
    protected Vector bandwidthList = new Vector();
    protected Vector attributesList;

    public SessionDescriptionImpl() {
        this.timeDescriptions = new Vector();
        this.mediaDescriptions = new Vector();
        this.attributesList = new Vector();
    }

    public void addField(SDPField sdpField) throws ParseException {
        try {
            if (sdpField instanceof ProtoVersionField) {
                this.versionImpl = (ProtoVersionField)sdpField;
            } else if (sdpField instanceof OriginField) {
                this.originImpl = (OriginField)sdpField;
            } else if (sdpField instanceof SessionNameField) {
                this.sessionNameImpl = (SessionNameField)sdpField;
            } else if (sdpField instanceof InformationField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setInformationField((InformationField)sdpField);
                } else {
                    this.infoImpl = (InformationField)sdpField;
                }
            } else if (sdpField instanceof URIField) {
                this.uriImpl = (URIField)sdpField;
            } else if (sdpField instanceof ConnectionField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setConnectionField((ConnectionField)sdpField);
                } else {
                    this.connectionImpl = (ConnectionField)sdpField;
                }
            } else if (sdpField instanceof KeyField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setKey((KeyField)sdpField);
                } else {
                    this.keyImpl = (KeyField)sdpField;
                }
            } else if (sdpField instanceof EmailField) {
                this.emailList.add(sdpField);
            } else if (sdpField instanceof PhoneField) {
                this.phoneList.add(sdpField);
            } else if (sdpField instanceof TimeField) {
                this.currentTimeDescription = new TimeDescriptionImpl((TimeField)sdpField);
                this.timeDescriptions.add(this.currentTimeDescription);
            } else if (sdpField instanceof RepeatField) {
                if (this.currentTimeDescription == null) {
                    throw new ParseException("no time specified", 0);
                }
                this.currentTimeDescription.addRepeatField((RepeatField)sdpField);
            } else if (sdpField instanceof ZoneField) {
                this.zoneAdjustments.add(sdpField);
            } else if (sdpField instanceof BandwidthField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.addBandwidthField((BandwidthField)sdpField);
                } else {
                    this.bandwidthList.add(sdpField);
                }
            } else if (sdpField instanceof AttributeField) {
                if (this.currentMediaDescription != null) {
                    AttributeField af = (AttributeField)sdpField;
                    String s = af.getName();
                    this.currentMediaDescription.addAttribute((AttributeField)sdpField);
                } else {
                    this.attributesList.add(sdpField);
                }
            } else if (sdpField instanceof MediaField) {
                this.currentMediaDescription = new MediaDescriptionImpl();
                this.mediaDescriptions.add(this.currentMediaDescription);
                this.currentMediaDescription.setMediaField((MediaField)sdpField);
            }
        }
        catch (SdpException ex) {
            throw new ParseException(sdpField.encode(), 0);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SessionDescriptionImpl hi;
        Class<?> myClass = this.getClass();
        try {
            hi = (SessionDescriptionImpl)myClass.newInstance();
        }
        catch (InstantiationException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        hi.versionImpl = (ProtoVersionField)this.versionImpl.clone();
        hi.originImpl = (OriginField)this.originImpl.clone();
        hi.sessionNameImpl = (SessionNameField)this.sessionNameImpl.clone();
        if (this.infoImpl != null) {
            hi.infoImpl = (InformationField)this.infoImpl.clone();
        }
        if (this.uriImpl != null) {
            hi.uriImpl = (URIField)this.uriImpl.clone();
        }
        if (this.connectionImpl != null) {
            hi.connectionImpl = (ConnectionField)this.connectionImpl.clone();
        }
        if (this.keyImpl != null) {
            hi.keyImpl = (KeyField)this.keyImpl.clone();
        }
        hi.timeDescriptions = (Vector)this.timeDescriptions.clone();
        hi.emailList = (Vector)this.emailList.clone();
        hi.phoneList = (Vector)this.phoneList.clone();
        hi.zoneAdjustments = (Vector)this.zoneAdjustments.clone();
        hi.bandwidthList = (Vector)this.bandwidthList.clone();
        hi.attributesList = (Vector)this.attributesList.clone();
        hi.mediaDescriptions = (Vector)this.mediaDescriptions.clone();
        return hi;
    }

    @Override
    public Version getVersion() {
        return this.versionImpl;
    }

    @Override
    public void setVersion(Version v) throws SdpException {
        if (v == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(v instanceof ProtoVersionField)) {
            throw new SdpException("The parameter must be an instance of VersionField");
        }
        this.versionImpl = (ProtoVersionField)v;
    }

    @Override
    public Origin getOrigin() {
        return this.originImpl;
    }

    @Override
    public void setOrigin(Origin origin) throws SdpException {
        OriginField o;
        if (origin == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(origin instanceof OriginField)) {
            throw new SdpException("The parameter must be an instance of OriginField");
        }
        this.originImpl = o = (OriginField)origin;
    }

    @Override
    public SessionName getSessionName() {
        return this.sessionNameImpl;
    }

    @Override
    public void setSessionName(SessionName sessionName) throws SdpException {
        SessionNameField s;
        if (sessionName == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(sessionName instanceof SessionNameField)) {
            throw new SdpException("The parameter must be an instance of SessionNameField");
        }
        this.sessionNameImpl = s = (SessionNameField)sessionName;
    }

    @Override
    public Info getInfo() {
        return this.infoImpl;
    }

    @Override
    public void setInfo(Info i) throws SdpException {
        InformationField info;
        if (i == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(i instanceof InformationField)) {
            throw new SdpException("The parameter must be an instance of InformationField");
        }
        this.infoImpl = info = (InformationField)i;
    }

    @Override
    public URI getURI() {
        return this.uriImpl;
    }

    @Override
    public void setURI(URI uri) throws SdpException {
        URIField u;
        if (uri == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(uri instanceof URIField)) {
            throw new SdpException("The parameter must be an instance of URIField");
        }
        this.uriImpl = u = (URIField)uri;
    }

    @Override
    public Vector getEmails(boolean create) throws SdpParseException {
        if (this.emailList == null && create) {
            this.emailList = new Vector();
        }
        return this.emailList;
    }

    @Override
    public void setEmails(Vector emails) throws SdpException {
        if (emails == null) {
            throw new SdpException("The parameter is null");
        }
        this.emailList = emails;
    }

    @Override
    public Vector getPhones(boolean create) throws SdpException {
        if (this.phoneList == null && create) {
            this.phoneList = new Vector();
        }
        return this.phoneList;
    }

    @Override
    public void setPhones(Vector phones) throws SdpException {
        if (phones == null) {
            throw new SdpException("The parameter is null");
        }
        this.phoneList = phones;
    }

    @Override
    public Vector getTimeDescriptions(boolean create) throws SdpException {
        if (this.timeDescriptions == null && create) {
            this.timeDescriptions = new Vector();
        }
        return this.timeDescriptions;
    }

    @Override
    public void setTimeDescriptions(Vector times) throws SdpException {
        if (times == null) {
            throw new SdpException("The parameter is null");
        }
        this.timeDescriptions = times;
    }

    @Override
    public Vector getZoneAdjustments(boolean create) throws SdpException {
        if (this.zoneAdjustments == null && create) {
            this.zoneAdjustments = new Vector();
        }
        return this.zoneAdjustments;
    }

    @Override
    public void setZoneAdjustments(Vector zoneAdjustments) throws SdpException {
        if (zoneAdjustments == null) {
            throw new SdpException("The parameter is null");
        }
        this.zoneAdjustments = zoneAdjustments;
    }

    @Override
    public Connection getConnection() {
        return this.connectionImpl;
    }

    @Override
    public void setConnection(Connection conn) throws SdpException {
        ConnectionField c;
        if (conn == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(conn instanceof ConnectionField)) {
            throw new SdpException("Bad implementation class ConnectionField");
        }
        this.connectionImpl = c = (ConnectionField)conn;
    }

    @Override
    public Vector getBandwidths(boolean create) {
        if (this.bandwidthList == null && create) {
            this.bandwidthList = new Vector();
        }
        return this.bandwidthList;
    }

    @Override
    public void setBandwidths(Vector bandwidthList) throws SdpException {
        if (bandwidthList == null) {
            throw new SdpException("The parameter is null");
        }
        this.bandwidthList = bandwidthList;
    }

    @Override
    public int getBandwidth(String name) throws SdpParseException {
        if (name == null) {
            return -1;
        }
        if (this.bandwidthList == null) {
            return -1;
        }
        for (int i = 0; i < this.bandwidthList.size(); ++i) {
            BandwidthField b;
            String type;
            Object o = this.bandwidthList.elementAt(i);
            if (!(o instanceof BandwidthField) || (type = (b = (BandwidthField)o).getType()) == null || !name.equals(type)) continue;
            return b.getValue();
        }
        return -1;
    }

    @Override
    public void setBandwidth(String name, int value) throws SdpException {
        if (name == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.bandwidthList != null) {
            for (int i = 0; i < this.bandwidthList.size(); ++i) {
                BandwidthField b;
                String type;
                Object o = this.bandwidthList.elementAt(i);
                if (!(o instanceof BandwidthField) || (type = (b = (BandwidthField)o).getType()) == null || !name.equals(type)) continue;
                b.setValue(value);
            }
        }
    }

    @Override
    public void removeBandwidth(String name) {
        if (name != null && this.bandwidthList != null) {
            for (int i = 0; i < this.bandwidthList.size(); ++i) {
                Object o = this.bandwidthList.elementAt(i);
                if (!(o instanceof BandwidthField)) continue;
                BandwidthField b = (BandwidthField)o;
                try {
                    String type = b.getType();
                    if (type == null || !name.equals(type)) continue;
                    this.bandwidthList.remove(b);
                    continue;
                }
                catch (SdpParseException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Key getKey() {
        return this.keyImpl;
    }

    @Override
    public void setKey(Key key) throws SdpException {
        KeyField k;
        if (key == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(key instanceof KeyField)) {
            throw new SdpException("The parameter must be an instance of KeyField");
        }
        this.keyImpl = k = (KeyField)key;
    }

    @Override
    public String getAttribute(String name) throws SdpParseException {
        if (name == null) {
            return null;
        }
        if (this.attributesList == null) {
            return null;
        }
        for (int i = 0; i < this.attributesList.size(); ++i) {
            AttributeField a;
            String n;
            Object o = this.attributesList.elementAt(i);
            if (!(o instanceof AttributeField) || (n = (a = (AttributeField)o).getName()) == null || !name.equals(n)) continue;
            return a.getValue();
        }
        return null;
    }

    @Override
    public Vector getAttributes(boolean create) {
        if (this.attributesList == null && create) {
            this.attributesList = new Vector();
        }
        return this.attributesList;
    }

    @Override
    public void removeAttribute(String name) {
        if (name != null && this.attributesList != null) {
            for (int i = 0; i < this.attributesList.size(); ++i) {
                Object o = this.attributesList.elementAt(i);
                if (!(o instanceof AttributeField)) continue;
                AttributeField a = (AttributeField)o;
                try {
                    String n = a.getName();
                    if (n == null || !name.equals(n)) continue;
                    this.attributesList.remove(a);
                    continue;
                }
                catch (SdpParseException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setAttribute(String name, String value) throws SdpException {
        if (name == null || value == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.attributesList != null) {
            for (int i = 0; i < this.attributesList.size(); ++i) {
                AttributeField a;
                String n;
                Object o = this.attributesList.elementAt(i);
                if (!(o instanceof AttributeField) || (n = (a = (AttributeField)o).getName()) == null || !name.equals(n)) continue;
                a.setValue(value);
            }
        }
    }

    @Override
    public void setAttributes(Vector attributes) throws SdpException {
        if (attributes == null) {
            throw new SdpException("The parameter is null");
        }
        this.attributesList = attributes;
    }

    @Override
    public Vector getMediaDescriptions(boolean create) throws SdpException {
        if (this.mediaDescriptions == null && create) {
            this.mediaDescriptions = new Vector();
        }
        return this.mediaDescriptions;
    }

    @Override
    public void setMediaDescriptions(Vector mediaDescriptions) throws SdpException {
        if (mediaDescriptions == null) {
            throw new SdpException("The parameter is null");
        }
        this.mediaDescriptions = mediaDescriptions;
    }

    private String encodeVector(Vector vector) {
        StringBuffer encBuff = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            encBuff.append(vector.elementAt(i));
        }
        return encBuff.toString();
    }

    public String toString() {
        StringBuffer encBuff = new StringBuffer();
        encBuff.append(this.getVersion() == null ? "" : this.getVersion().toString());
        encBuff.append(this.getOrigin() == null ? "" : this.getOrigin().toString());
        encBuff.append(this.getSessionName() == null ? "" : this.getSessionName().toString());
        encBuff.append(this.getInfo() == null ? "" : this.getInfo().toString());
        try {
            encBuff.append(this.getURI() == null ? "" : this.getURI().toString());
            encBuff.append(this.encodeVector(this.getEmails(true)));
            encBuff.append(this.encodeVector(this.getPhones(true)));
            encBuff.append(this.getConnection() == null ? "" : this.getConnection().toString());
            encBuff.append(this.encodeVector(this.getBandwidths(true)));
            encBuff.append(this.encodeVector(this.getTimeDescriptions(true)));
            encBuff.append(this.encodeVector(this.getZoneAdjustments(true)));
            encBuff.append(this.getKey() == null ? "" : this.getKey().toString());
            encBuff.append(this.encodeVector(this.getAttributes(true)));
            encBuff.append(this.encodeVector(this.getMediaDescriptions(true)));
        }
        catch (SdpException sdpException) {
            // empty catch block
        }
        return encBuff.toString();
    }

    @Override
    public byte[] toBytes() {
        try {
            return this.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            this.LOG.error("Should never happen", (Throwable)e);
            throw new IllegalArgumentException("Bad SDP??" + this);
        }
    }
}

