/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp;

import java.text.ParseException;
import java.util.Vector;

public class StringTokenizer {
    protected String buffer;
    protected int ptr;
    protected int savedPtr;

    public StringTokenizer() {
    }

    public StringTokenizer(String buffer) {
        this.buffer = buffer;
        this.ptr = 0;
    }

    public String nextToken() {
        StringBuffer retval = new StringBuffer();
        while (this.ptr < this.buffer.length()) {
            if (this.buffer.charAt(this.ptr) == '\n') {
                retval.append(this.buffer.charAt(this.ptr));
                ++this.ptr;
                break;
            }
            retval.append(this.buffer.charAt(this.ptr));
            ++this.ptr;
        }
        return retval.toString();
    }

    public boolean hasMoreChars() {
        return this.ptr < this.buffer.length();
    }

    public static boolean isHexDigit(char ch) {
        if (StringTokenizer.isDigit(ch)) {
            return true;
        }
        char ch1 = Character.toUpperCase(ch);
        return ch1 == 'A' || ch1 == 'B' || ch1 == 'C' || ch1 == 'D' || ch1 == 'E' || ch1 == 'F';
    }

    public static boolean isAlpha(char ch) {
        boolean retval = Character.isUpperCase(ch) || Character.isLowerCase(ch);
        return retval;
    }

    public static boolean isDigit(char ch) {
        boolean retval = Character.isDigit(ch);
        return retval;
    }

    public String getLine() {
        StringBuffer retval = new StringBuffer();
        while (this.ptr < this.buffer.length() && this.buffer.charAt(this.ptr) != '\n') {
            retval.append(this.buffer.charAt(this.ptr));
            ++this.ptr;
        }
        if (this.ptr < this.buffer.length() && this.buffer.charAt(this.ptr) == '\n') {
            retval.append('\n');
            ++this.ptr;
        }
        return retval.toString();
    }

    public String peekLine() {
        int curPos = this.ptr;
        String retval = this.getLine();
        this.ptr = curPos;
        return retval;
    }

    public char lookAhead() throws ParseException {
        return this.lookAhead(0);
    }

    public char lookAhead(int k) throws ParseException {
        if (this.ptr + k < this.buffer.length()) {
            return this.buffer.charAt(this.ptr + k);
        }
        return '\u0000';
    }

    public char getNextChar() throws ParseException {
        if (this.ptr >= this.buffer.length()) {
            throw new ParseException(this.buffer + " getNextChar: End of buffer", this.ptr);
        }
        return this.buffer.charAt(this.ptr++);
    }

    public void consume() {
        this.ptr = this.savedPtr;
    }

    public void consume(int k) {
        this.ptr += k;
    }

    public Vector getLines() {
        Vector<String> result = new Vector<String>();
        while (this.hasMoreChars()) {
            String line = this.getLine();
            result.addElement(line);
        }
        return result;
    }

    public String getNextToken(char delim) throws ParseException {
        char la;
        StringBuffer retval = new StringBuffer();
        while ((la = this.lookAhead(0)) != delim) {
            if (la == '\u0000') {
                throw new ParseException("EOL reached", 0);
            }
            retval.append(this.buffer.charAt(this.ptr));
            this.consume(1);
        }
        return retval.toString();
    }

    public static String getSDPFieldName(String line) {
        if (line == null) {
            return null;
        }
        String fieldName = null;
        try {
            int begin = line.indexOf("=");
            fieldName = line.substring(0, begin);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return fieldName;
    }
}

