/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.api;

import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.lastbamboo.common.sdp.MediaDescriptionImpl;
import org.lastbamboo.common.sdp.SessionDescriptionImpl;
import org.lastbamboo.common.sdp.TimeDescriptionImpl;
import org.lastbamboo.common.sdp.api.Attribute;
import org.lastbamboo.common.sdp.api.BandWidth;
import org.lastbamboo.common.sdp.api.Connection;
import org.lastbamboo.common.sdp.api.EMail;
import org.lastbamboo.common.sdp.api.Info;
import org.lastbamboo.common.sdp.api.Key;
import org.lastbamboo.common.sdp.api.Media;
import org.lastbamboo.common.sdp.api.MediaDescription;
import org.lastbamboo.common.sdp.api.Origin;
import org.lastbamboo.common.sdp.api.Phone;
import org.lastbamboo.common.sdp.api.RepeatTime;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.api.SessionDescription;
import org.lastbamboo.common.sdp.api.SessionName;
import org.lastbamboo.common.sdp.api.Time;
import org.lastbamboo.common.sdp.api.TimeDescription;
import org.lastbamboo.common.sdp.api.TimeZoneAdjustment;
import org.lastbamboo.common.sdp.api.URI;
import org.lastbamboo.common.sdp.api.Version;
import org.lastbamboo.common.sdp.fields.AttributeField;
import org.lastbamboo.common.sdp.fields.BandwidthField;
import org.lastbamboo.common.sdp.fields.ConnectionField;
import org.lastbamboo.common.sdp.fields.EmailField;
import org.lastbamboo.common.sdp.fields.InformationField;
import org.lastbamboo.common.sdp.fields.KeyField;
import org.lastbamboo.common.sdp.fields.MediaField;
import org.lastbamboo.common.sdp.fields.OriginField;
import org.lastbamboo.common.sdp.fields.PhoneField;
import org.lastbamboo.common.sdp.fields.ProtoVersionField;
import org.lastbamboo.common.sdp.fields.RepeatField;
import org.lastbamboo.common.sdp.fields.SessionNameField;
import org.lastbamboo.common.sdp.fields.TimeField;
import org.lastbamboo.common.sdp.fields.URIField;
import org.lastbamboo.common.sdp.fields.ZoneField;
import org.lastbamboo.common.sdp.parser.SDPAnnounceParser;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdpFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SdpFactory.class);
    protected static final List sessionDescriptionsList = Collections.synchronizedList(new LinkedList());

    public static SdpFactory getInstance() {
        return new SdpFactory();
    }

    public SessionDescription createSessionDescription() throws SdpException {
        SessionDescriptionImpl sessionDescriptionImpl = new SessionDescriptionImpl();
        ProtoVersionField ProtoVersionField2 = new ProtoVersionField();
        ProtoVersionField2.setVersion(0);
        sessionDescriptionImpl.setVersion(ProtoVersionField2);
        OriginField originImpl = null;
        try {
            originImpl = (OriginField)this.createOrigin("user", NetworkUtils.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        sessionDescriptionImpl.setOrigin(originImpl);
        SessionNameField sessionNameImpl = new SessionNameField();
        sessionNameImpl.setValue("-");
        sessionDescriptionImpl.setSessionName(sessionNameImpl);
        TimeDescriptionImpl timeDescriptionImpl = new TimeDescriptionImpl();
        TimeField timeImpl = new TimeField();
        timeImpl.setZero();
        timeDescriptionImpl.setTime(timeImpl);
        Vector<TimeDescriptionImpl> times = new Vector<TimeDescriptionImpl>();
        times.addElement(timeDescriptionImpl);
        sessionDescriptionImpl.setTimeDescriptions(times);
        return sessionDescriptionImpl;
    }

    public SessionDescription createSessionDescription(String s) throws SdpParseException {
        try {
            SDPAnnounceParser sdpParser = new SDPAnnounceParser(s);
            return sdpParser.parse();
        }
        catch (ParseException e) {
            LOG.warn("Could not parse SDP", (Throwable)e);
            throw new SdpParseException(0, 0, "Could not parse message", e);
        }
    }

    public BandWidth createBandwidth(String modifier, int value) {
        BandwidthField bandWidthImpl = new BandwidthField();
        try {
            bandWidthImpl.setType(modifier);
            bandWidthImpl.setValue(value);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return bandWidthImpl;
    }

    public Attribute createAttribute(String name, String value) {
        AttributeField attributeImpl = new AttributeField();
        try {
            attributeImpl.setName(name);
            attributeImpl.setValue(value);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return attributeImpl;
    }

    public Info createInfo(String value) {
        InformationField infoImpl = new InformationField();
        try {
            infoImpl.setValue(value);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return infoImpl;
    }

    public Phone createPhone(String value) {
        PhoneField phoneImpl = new PhoneField();
        try {
            phoneImpl.setValue(value);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return phoneImpl;
    }

    public EMail createEMail(String value) {
        EmailField emailImpl = new EmailField();
        try {
            emailImpl.setValue(value);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return emailImpl;
    }

    public URI createURI(URL value) {
        URIField uriImpl = new URIField();
        uriImpl.set(value);
        return uriImpl;
    }

    public SessionName createSessionName(String name) {
        SessionNameField sessionNameImpl = new SessionNameField();
        try {
            sessionNameImpl.setValue(name);
        }
        catch (SdpException e) {
            LOG.warn("Could not set value", (Throwable)e);
        }
        return sessionNameImpl;
    }

    public Key createKey(String method, String key) {
        KeyField keyImpl = new KeyField();
        try {
            keyImpl.setMethod(method);
            keyImpl.setKey(key);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
            return null;
        }
        return keyImpl;
    }

    public Version createVersion(int value) {
        ProtoVersionField protoVersionField = new ProtoVersionField();
        try {
            protoVersionField.setVersion(value);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
            return null;
        }
        return protoVersionField;
    }

    public Media createMedia(String media, int port, int numPorts, String transport, Vector staticRtpAvpTypes) throws SdpException {
        MediaField mediaImpl = new MediaField();
        mediaImpl.setMediaType(media);
        mediaImpl.setMediaPort(port);
        mediaImpl.setPortCount(numPorts);
        mediaImpl.setProtocol(transport);
        mediaImpl.setMediaFormats(staticRtpAvpTypes);
        return mediaImpl;
    }

    public Origin createOrigin(String userName, String address) throws SdpException {
        OriginField originImpl = new OriginField();
        originImpl.setUsername(userName);
        originImpl.setAddress(address);
        originImpl.setNetworkType("IN");
        originImpl.setAddressType("IP4");
        return originImpl;
    }

    public Origin createOrigin(String userName, long sessionId, long sessionVersion, String networkType, String addrType, String address) throws SdpException {
        OriginField originImpl = new OriginField();
        originImpl.setUsername(userName);
        originImpl.setAddress(address);
        originImpl.setSessionId(sessionId);
        originImpl.setSessionVersion(sessionVersion);
        originImpl.setAddressType(addrType);
        originImpl.setNetworkType(networkType);
        return originImpl;
    }

    public MediaDescription createMediaDescription(String media, int port, int numPorts, String transport, int[] staticRtpAvpTypes) throws IllegalArgumentException, SdpException {
        MediaDescriptionImpl mediaDescriptionImpl = new MediaDescriptionImpl();
        MediaField mediaImpl = new MediaField();
        mediaImpl.setMediaType(media);
        mediaImpl.setMediaPort(port);
        mediaImpl.setPortCount(numPorts);
        mediaImpl.setProtocol(transport);
        mediaDescriptionImpl.setMedia(mediaImpl);
        Vector<String> payload = new Vector<String>();
        for (int i = 0; i < staticRtpAvpTypes.length; ++i) {
            payload.add(new Integer(staticRtpAvpTypes[i]).toString());
        }
        mediaImpl.setMediaFormats(payload);
        return mediaDescriptionImpl;
    }

    public MediaDescription createMediaDescription(String media, int port, int numPorts, String transport, String[] formats) {
        MediaDescriptionImpl mediaDescriptionImpl = new MediaDescriptionImpl();
        try {
            MediaField mediaImpl = new MediaField();
            mediaImpl.setMediaType(media);
            mediaImpl.setMediaPort(port);
            mediaImpl.setPortCount(numPorts);
            mediaImpl.setProtocol(transport);
            Vector<String> formatsV = new Vector<String>(formats.length);
            for (int i = 0; i < formats.length; ++i) {
                formatsV.add(formats[i]);
            }
            mediaImpl.setMediaFormats(formatsV);
            mediaDescriptionImpl.setMedia(mediaImpl);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return mediaDescriptionImpl;
    }

    public TimeDescription createTimeDescription(Time t) throws SdpException {
        TimeDescriptionImpl timeDescriptionImpl = new TimeDescriptionImpl();
        timeDescriptionImpl.setTime(t);
        return timeDescriptionImpl;
    }

    public TimeDescription createTimeDescription() throws SdpException {
        TimeDescriptionImpl timeDescriptionImpl = new TimeDescriptionImpl();
        TimeField timeImpl = new TimeField();
        timeImpl.setZero();
        timeDescriptionImpl.setTime(timeImpl);
        return timeDescriptionImpl;
    }

    public TimeDescription createTimeDescription(Date start, Date stop) throws SdpException {
        TimeDescriptionImpl timeDescriptionImpl = new TimeDescriptionImpl();
        TimeField timeImpl = new TimeField();
        timeImpl.setStart(start);
        timeImpl.setStop(stop);
        timeDescriptionImpl.setTime(timeImpl);
        return timeDescriptionImpl;
    }

    public String formatMulticastAddress(String addr, int ttl, int numAddrs) {
        String res = addr + "/" + ttl + "/" + numAddrs;
        return res;
    }

    public Connection createConnection(String netType, String addrType, String addr, int ttl, int numAddrs) throws SdpException {
        ConnectionField connectionImpl = new ConnectionField();
        connectionImpl.setNetworkType(netType);
        connectionImpl.setAddressType(addrType);
        connectionImpl.setAddress(addr);
        return connectionImpl;
    }

    public Connection createConnection(String netType, String addrType, String addr) throws SdpException {
        ConnectionField connectionImpl = new ConnectionField();
        connectionImpl.setNetworkType(netType);
        connectionImpl.setAddressType(addrType);
        connectionImpl.setAddress(addr);
        return connectionImpl;
    }

    public Connection createConnection(String addr, int ttl, int numAddrs) throws SdpException {
        ConnectionField connectionImpl = new ConnectionField();
        connectionImpl.setAddress(addr);
        return connectionImpl;
    }

    public Connection createConnection(String addr) throws SdpException {
        return this.createConnection("IN", "IP4", addr);
    }

    public Time createTime(Date start, Date stop) throws SdpException {
        TimeField timeImpl = new TimeField();
        timeImpl.setStart(start);
        timeImpl.setStop(stop);
        return timeImpl;
    }

    public Time createTime() {
        TimeField timeImpl = new TimeField();
        timeImpl.setZero();
        return timeImpl;
    }

    public RepeatTime createRepeatTime(int repeatInterval, int activeDuration, int[] offsets) {
        RepeatField repeatTimeField = new RepeatField();
        try {
            repeatTimeField.setRepeatInterval(repeatInterval);
            repeatTimeField.setActiveDuration(activeDuration);
            repeatTimeField.setOffsetArray(offsets);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return repeatTimeField;
    }

    public TimeZoneAdjustment createTimeZoneAdjustment(Date d, int offset) {
        ZoneField timeZoneAdjustmentImpl = new ZoneField();
        try {
            Hashtable<Date, Integer> map = new Hashtable<Date, Integer>();
            map.put(d, new Integer(offset));
            timeZoneAdjustmentImpl.setZoneAdjustments(map);
        }
        catch (SdpException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
        }
        return timeZoneAdjustmentImpl;
    }

    public static Vector findSessions(String source) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Date getDateFromNtp(long ntpTime) {
        return new Date((ntpTime - 2208988800L) * 1000L);
    }

    public static long getNtpTime(Date d) {
        if (d == null) {
            return -1L;
        }
        return d.getTime() / 1000L + 2208988800L;
    }
}

