/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import org.lastbamboo.common.sdp.NameValue;
import org.lastbamboo.common.sdp.api.Attribute;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.SDPField;

public class AttributeField
extends SDPField
implements Attribute {
    protected NameValue attribute;

    public NameValue getAttribute() {
        return this.attribute;
    }

    public AttributeField() {
        super("a=");
    }

    public void setAttribute(NameValue a) {
        this.attribute = a;
        this.attribute.setSeparator(":");
    }

    @Override
    public String encode() {
        String encoded_string = "a=";
        if (this.attribute != null) {
            encoded_string = encoded_string + this.attribute.encode();
        }
        return encoded_string + "\r\n";
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getName() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        String name = nameValue.getName();
        if (name == null) {
            return null;
        }
        return name;
    }

    @Override
    public void setName(String name) throws SdpException {
        if (name == null) {
            throw new SdpException("The name is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setName(name);
        this.setAttribute(nameValue);
    }

    @Override
    public boolean hasValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return false;
        }
        Object value = nameValue.getValue();
        return value != null;
    }

    @Override
    public String getValue() throws SdpParseException {
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            return null;
        }
        Object value = nameValue.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    @Override
    public void setValue(String value) throws SdpException {
        if (value == null) {
            throw new SdpException("The value is null");
        }
        NameValue nameValue = this.getAttribute();
        if (nameValue == null) {
            nameValue = new NameValue();
        }
        nameValue.setValue(value);
        this.setAttribute(nameValue);
    }

    @Override
    public Object clone() {
        AttributeField retval = (AttributeField)super.clone();
        if (this.attribute != null) {
            retval.attribute = (NameValue)this.attribute.clone();
        }
        return retval;
    }
}

