/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import org.lastbamboo.common.sdp.Host;
import org.lastbamboo.common.sdp.api.Connection;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.ConnectionAddress;
import org.lastbamboo.common.sdp.fields.SDPField;

public class ConnectionField
extends SDPField
implements Connection {
    protected String nettype;
    protected String addrtype;
    protected ConnectionAddress address;

    public ConnectionField() {
        super("c=");
    }

    public String getNettype() {
        return this.nettype;
    }

    public String getAddrtype() {
        return this.addrtype;
    }

    public ConnectionAddress getConnectionAddress() {
        return this.address;
    }

    public void setNettype(String n) {
        this.nettype = n;
    }

    public void setAddrType(String a) {
        this.addrtype = a;
    }

    public void setAddress(ConnectionAddress a) {
        this.address = a;
    }

    @Override
    public String encode() {
        String encoded_string = "c=";
        if (this.nettype != null) {
            encoded_string = encoded_string + this.nettype;
        }
        if (this.addrtype != null) {
            encoded_string = encoded_string + " " + this.addrtype;
        }
        if (this.address != null) {
            encoded_string = encoded_string + " " + this.address.encode();
        }
        encoded_string = encoded_string + "\r\n";
        return encoded_string;
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getAddress() throws SdpParseException {
        ConnectionAddress connectionAddress = this.getConnectionAddress();
        if (connectionAddress == null) {
            return null;
        }
        Host host = connectionAddress.getAddress();
        if (host == null) {
            return null;
        }
        return host.getAddress();
    }

    @Override
    public String getAddressType() throws SdpParseException {
        return this.getAddrtype();
    }

    @Override
    public String getNetworkType() throws SdpParseException {
        return this.getNettype();
    }

    @Override
    public void setAddress(String addr) throws SdpException {
        if (addr == null) {
            throw new SdpException("the addr is null");
        }
        if (this.address == null) {
            this.address = new ConnectionAddress();
            Host host = new Host(addr);
            this.address.setAddress(host);
        } else {
            Host host = this.address.getAddress();
            if (host == null) {
                host = new Host(addr);
                this.address.setAddress(host);
            } else {
                host.setAddress(addr);
            }
        }
        this.setAddress(this.address);
    }

    @Override
    public void setAddressType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("the type is null");
        }
        this.addrtype = type;
    }

    @Override
    public void setNetworkType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("the type is null");
        }
        this.setNettype(type);
    }

    @Override
    public Object clone() {
        ConnectionField retval = (ConnectionField)super.clone();
        if (this.address != null) {
            retval.address = (ConnectionAddress)this.address.clone();
        }
        return retval;
    }
}

