/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import org.lastbamboo.common.sdp.api.EMail;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.EmailAddress;
import org.lastbamboo.common.sdp.fields.SDPField;

public class EmailField
extends SDPField
implements EMail {
    protected EmailAddress emailAddress = new EmailAddress();

    public EmailField() {
        super("e=");
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public String encode() {
        return "e=" + this.emailAddress.encode() + "\r\n";
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public String getValue() throws SdpParseException {
        if (this.emailAddress == null) {
            return null;
        }
        return this.emailAddress.getDisplayName();
    }

    @Override
    public void setValue(String value) throws SdpException {
        if (value == null) {
            throw new SdpException("The value is null");
        }
        this.emailAddress.setDisplayName(value);
    }

    @Override
    public Object clone() {
        EmailField retval = (EmailField)super.clone();
        if (this.emailAddress != null) {
            retval.emailAddress = (EmailAddress)this.emailAddress.clone();
        }
        return retval;
    }
}

