/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import org.lastbamboo.common.sdp.api.Key;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.SDPField;

public class KeyField
extends SDPField
implements Key {
    protected String type;
    protected String keyData;

    public KeyField() {
        super("k=");
    }

    public String getType() {
        return this.type;
    }

    public String getKeyData() {
        return this.keyData;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setKeyData(String k) {
        this.keyData = k;
    }

    @Override
    public String encode() {
        String encoded_string = "k=" + this.type;
        if (this.keyData != null) {
            encoded_string = encoded_string + ":";
            encoded_string = encoded_string + this.keyData;
        }
        encoded_string = encoded_string + "\r\n";
        return encoded_string;
    }

    @Override
    public String getMethod() throws SdpParseException {
        return this.type;
    }

    @Override
    public void setMethod(String name) throws SdpException {
        this.type = name;
    }

    @Override
    public boolean hasKey() throws SdpParseException {
        String key = this.getKeyData();
        return key != null;
    }

    @Override
    public String getKey() throws SdpParseException {
        return this.getKeyData();
    }

    @Override
    public void setKey(String key) throws SdpException {
        if (key == null) {
            throw new SdpException("The key is null");
        }
        this.setKeyData(key);
    }
}

