/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import org.lastbamboo.common.sdp.Host;
import org.lastbamboo.common.sdp.api.Origin;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.SDPField;

public class OriginField
extends SDPField
implements Origin {
    protected String username;
    protected long sessId;
    protected long sessVersion;
    protected String nettype;
    protected String addrtype;
    protected Host address;

    public OriginField() {
        super("o=");
    }

    @Override
    public String getUsername() throws SdpParseException {
        return this.username;
    }

    public long getSessId() {
        return this.sessId;
    }

    public long getSessVersion() {
        return this.sessVersion;
    }

    public String getNettype() {
        return this.nettype;
    }

    public String getAddrtype() {
        return this.addrtype;
    }

    public Host getHost() {
        return this.address;
    }

    public void setSessId(long s) {
        this.sessId = s;
    }

    public void setSessVersion(long s) {
        this.sessVersion = s;
    }

    public void setNettype(String n) {
        this.nettype = n;
    }

    public void setAddrtype(String a) {
        this.addrtype = a;
    }

    public void setAddress(Host a) {
        this.address = a;
    }

    @Override
    public void setUsername(String user) throws SdpException {
        if (user == null) {
            throw new SdpException("The user parameter is null");
        }
        this.username = user;
    }

    @Override
    public long getSessionId() throws SdpParseException {
        return this.getSessId();
    }

    @Override
    public void setSessionId(long id) throws SdpException {
        if (id < 0L) {
            throw new SdpException("The is parameter is <0");
        }
        this.setSessId(id);
    }

    @Override
    public long getSessionVersion() throws SdpParseException {
        return this.getSessVersion();
    }

    @Override
    public void setSessionVersion(long version) throws SdpException {
        if (version < 0L) {
            throw new SdpException("The version parameter is <0");
        }
        this.setSessVersion(version);
    }

    @Override
    public String getAddress() throws SdpParseException {
        Host addr = this.getHost();
        if (addr == null) {
            return null;
        }
        return addr.getAddress();
    }

    @Override
    public String getAddressType() throws SdpParseException {
        return this.getAddrtype();
    }

    @Override
    public String getNetworkType() throws SdpParseException {
        return this.getNettype();
    }

    @Override
    public void setAddress(String addr) throws SdpException {
        if (addr == null) {
            throw new SdpException("The addr parameter is null");
        }
        Host host = this.getHost();
        if (host == null) {
            host = new Host();
        }
        host.setAddress(addr);
        this.setAddress(host);
    }

    @Override
    public void setAddressType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setAddrtype(type);
    }

    @Override
    public void setNetworkType(String type) throws SdpException {
        if (type == null) {
            throw new SdpException("The type parameter is <0");
        }
        this.setNettype(type);
    }

    @Override
    public String encode() {
        return "o=" + this.username + " " + this.sessId + " " + this.sessVersion + " " + this.nettype + " " + this.addrtype + " " + this.address.encode() + "\r\n";
    }

    @Override
    public Object clone() {
        OriginField retval = (OriginField)super.clone();
        if (this.address != null) {
            retval.address = (Host)this.address.clone();
        }
        return retval;
    }
}

