/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import java.util.LinkedList;
import java.util.ListIterator;
import org.lastbamboo.common.sdp.api.RepeatTime;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.fields.SDPObjectList;
import org.lastbamboo.common.sdp.fields.TypedTime;

public class RepeatField
extends SDPField
implements RepeatTime {
    protected TypedTime repeatInterval;
    protected TypedTime activeDuration;
    protected SDPObjectList offsets = new SDPObjectList();

    public RepeatField() {
        super("r=");
    }

    public void setRepeatInterval(TypedTime interval) {
        this.repeatInterval = interval;
    }

    public void setActiveDuration(TypedTime duration) {
        this.activeDuration = duration;
    }

    public void addOffset(TypedTime offset) {
        this.offsets.add(offset);
    }

    public LinkedList getOffsets() {
        return this.offsets;
    }

    @Override
    public int getRepeatInterval() throws SdpParseException {
        if (this.repeatInterval == null) {
            return -1;
        }
        return this.repeatInterval.getTime();
    }

    @Override
    public void setRepeatInterval(int repeatInterval) throws SdpException {
        if (repeatInterval < 0) {
            throw new SdpException("The repeat interval is <0");
        }
        if (this.repeatInterval == null) {
            this.repeatInterval = new TypedTime();
        }
        this.repeatInterval.setTime(repeatInterval);
    }

    @Override
    public int getActiveDuration() throws SdpParseException {
        if (this.activeDuration == null) {
            return -1;
        }
        return this.activeDuration.getTime();
    }

    @Override
    public void setActiveDuration(int activeDuration) throws SdpException {
        if (activeDuration < 0) {
            throw new SdpException("The active Duration is <0");
        }
        if (this.activeDuration == null) {
            this.activeDuration = new TypedTime();
        }
        this.activeDuration.setTime(activeDuration);
    }

    @Override
    public int[] getOffsetArray() throws SdpParseException {
        LinkedList linkedList = this.getOffsets();
        int[] result = new int[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            TypedTime typedTime = (TypedTime)linkedList.get(i);
            result[i] = typedTime.getTime();
        }
        return result;
    }

    @Override
    public void setOffsetArray(int[] offsets) throws SdpException {
        for (int i = 0; i < offsets.length; ++i) {
            TypedTime typedTime = new TypedTime();
            typedTime.setTime(offsets[i]);
            this.addOffset(typedTime);
        }
    }

    @Override
    public boolean getTypedTime() throws SdpParseException {
        return true;
    }

    @Override
    public void setTypedTime(boolean typedTime) {
    }

    @Override
    public String encode() {
        StringBuffer retval = new StringBuffer();
        retval.append("r=").append(this.repeatInterval.encode()).append(" ").append(this.activeDuration.encode());
        ListIterator li = this.offsets.listIterator();
        while (li.hasNext()) {
            TypedTime off = (TypedTime)li.next();
            retval.append(" ").append(off.encode());
        }
        retval.append("\r\n");
        return retval.toString();
    }

    @Override
    public Object clone() {
        RepeatField retval = (RepeatField)super.clone();
        if (this.repeatInterval != null) {
            retval.repeatInterval = (TypedTime)this.repeatInterval.clone();
        }
        if (this.activeDuration != null) {
            retval.activeDuration = (TypedTime)this.activeDuration.clone();
        }
        if (this.offsets != null) {
            retval.offsets = (SDPObjectList)this.offsets.clone();
        }
        return retval;
    }
}

