/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import java.util.LinkedList;
import java.util.ListIterator;
import org.lastbamboo.common.sdp.GenericObject;
import org.lastbamboo.common.sdp.GenericObjectList;
import org.lastbamboo.common.sdp.fields.SDPObject;

public class SDPObjectList
extends GenericObjectList {
    @Override
    public void mergeObjects(GenericObjectList mergeList) {
        if (!mergeList.getMyClass().equals(this.getMyClass())) {
            throw new IllegalArgumentException("class mismatch");
        }
        ListIterator it1 = this.listIterator();
        ListIterator it2 = mergeList.listIterator();
        while (it1.hasNext()) {
            GenericObject outerObj = (GenericObject)it1.next();
            while (it2.hasNext()) {
                Object innerObj = it2.next();
                outerObj.merge(innerObj);
            }
        }
    }

    public void add(SDPObject s) {
        super.add(s);
    }

    public SDPObjectList(String lname, Class clazz) {
        super(lname, clazz);
    }

    public SDPObjectList() {
        super(null, SDPObject.class);
    }

    public SDPObjectList(String lname) {
        super(lname, SDPObject.class);
    }

    @Override
    public GenericObject first() {
        return (SDPObject)super.first();
    }

    @Override
    public GenericObject next() {
        return (SDPObject)super.next();
    }

    @Override
    public GenericObject next(ListIterator li) {
        return (SDPObject)super.next(li);
    }

    @Override
    public String encode() {
        StringBuffer retval = new StringBuffer();
        SDPObject sdpObject = (SDPObject)this.first();
        while (sdpObject != null) {
            retval.append(sdpObject.encode());
            sdpObject = (SDPObject)this.next();
        }
        return retval.toString();
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public void replace(String objectText, GenericObject replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Cloneable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }

    @Override
    public void replace(String objectText, GenericObjectList replacementObject, boolean matchSubstring) throws IllegalArgumentException {
        if (objectText == null || replacementObject == null) {
            throw new IllegalArgumentException("null argument");
        }
        ListIterator listIterator = this.listIterator();
        LinkedList ll = new LinkedList();
        while (listIterator.hasNext()) {
            Cloneable gobj;
            Object obj = listIterator.next();
            if (GenericObject.isMySubclass(obj.getClass())) {
                gobj = (GenericObject)obj;
                if (!gobj.getClass().equals(replacementObject.getClass())) continue;
                if (!matchSubstring && ((GenericObject)gobj).encode().compareTo(objectText) == 0) {
                    ll.add(obj);
                    continue;
                }
                if (matchSubstring && ((GenericObject)gobj).encode().indexOf(objectText) >= 0) {
                    ll.add(obj);
                    continue;
                }
                ((GenericObject)gobj).replace(objectText, replacementObject, matchSubstring);
                continue;
            }
            if (!GenericObjectList.isMySubclass(obj.getClass()) || !(gobj = (GenericObjectList)obj).getClass().equals(replacementObject.getClass())) continue;
            if (!matchSubstring && ((GenericObjectList)gobj).encode().compareTo(objectText) == 0) {
                ll.add(obj);
                continue;
            }
            if (matchSubstring && ((GenericObjectList)gobj).encode().indexOf(objectText) >= 0) {
                ll.add(obj);
                continue;
            }
            ((GenericObjectList)gobj).replace(objectText, replacementObject, matchSubstring);
        }
        for (int i = 0; i < ll.size(); ++i) {
            Object obj = ll.get(i);
            this.remove(obj);
            this.add(i, replacementObject);
        }
    }
}

