/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import java.util.Date;
import org.lastbamboo.common.sdp.api.SdpException;
import org.lastbamboo.common.sdp.api.SdpParseException;
import org.lastbamboo.common.sdp.api.Time;
import org.lastbamboo.common.sdp.fields.SDPField;

public class TimeField
extends SDPField
implements Time {
    protected long startTime;
    protected long stopTime;

    public TimeField() {
        super("t=");
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

    @Override
    public Date getStart() throws SdpParseException {
        return new Date(this.startTime * 1000L + 2208988800L);
    }

    @Override
    public Date getStop() throws SdpParseException {
        return new Date(this.stopTime * 1000L + 2208988800L);
    }

    @Override
    public void setStop(Date stop) throws SdpException {
        if (stop == null) {
            throw new SdpException("The date is null");
        }
        this.stopTime = stop.getTime() / 1000L - 2208988800L;
    }

    @Override
    public void setStart(Date start) throws SdpException {
        if (start == null) {
            throw new SdpException("The date is null");
        }
        this.startTime = start.getTime() / 1000L - 2208988800L;
    }

    @Override
    public boolean getTypedTime() {
        return false;
    }

    @Override
    public void setTypedTime(boolean typedTime) {
    }

    @Override
    public boolean isZero() {
        long stopTime = this.getStopTime();
        long startTime = this.getStartTime();
        return stopTime == 0L && startTime == 0L;
    }

    @Override
    public void setZero() {
        this.setStopTime(0L);
        this.setStartTime(0L);
    }

    @Override
    public String encode() {
        return new StringBuffer().append("t=").append(this.startTime).append(" ").append(this.stopTime).append("\r\n").toString();
    }
}

