/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.fields;

import java.net.URL;
import org.lastbamboo.common.sdp.api.URI;
import org.lastbamboo.common.sdp.fields.SDPField;

public class URIField
extends SDPField
implements URI {
    protected URL url;
    protected String urlString;

    public URIField() {
        super("u=");
    }

    public String getURI() {
        return this.urlString;
    }

    public void setURI(String uri) {
        this.urlString = uri;
        this.url = null;
    }

    @Override
    public URL get() {
        if (this.url != null) {
            return this.url;
        }
        try {
            this.url = new URL(this.urlString);
            return this.url;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void set(URL uri) {
        this.url = uri;
        this.urlString = null;
    }

    @Override
    public String encode() {
        if (this.urlString != null) {
            return "u=" + this.urlString + "\r\n";
        }
        if (this.url != null) {
            return "u=" + this.url.toString() + "\r\n";
        }
        return "";
    }
}

