/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.text.ParseException;
import org.lastbamboo.common.sdp.fields.Email;
import org.lastbamboo.common.sdp.fields.EmailAddress;
import org.lastbamboo.common.sdp.fields.EmailField;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.SDPParser;

public class EmailFieldParser
extends SDPParser {
    public EmailFieldParser(String emailField) {
        this.lexer = new Lexer("charLexer", emailField);
    }

    public String getDisplayName(String rest) {
        String retval = null;
        try {
            int begin = rest.indexOf("(");
            int end = rest.indexOf(")");
            if (begin != -1) {
                retval = rest.substring(begin + 1, end);
            } else {
                int ind = rest.indexOf("<");
                if (ind != -1) {
                    retval = rest.substring(0, ind);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public Email getEmail(String rest) {
        Email email = new Email();
        try {
            int begin = rest.indexOf("(");
            if (begin != -1) {
                String emailTemp = rest.substring(0, begin);
                int i = emailTemp.indexOf("@");
                if (i != -1) {
                    email.setUserName(emailTemp.substring(0, i));
                    email.setHostName(emailTemp.substring(i + 1));
                }
            } else {
                int ind = rest.indexOf("<");
                int end = rest.indexOf(">");
                if (ind != -1) {
                    String emailTemp = rest.substring(ind + 1, end);
                    int i = emailTemp.indexOf("@");
                    if (i != -1) {
                        email.setUserName(emailTemp.substring(0, i));
                        email.setHostName(emailTemp.substring(i + 1));
                    }
                } else {
                    int i = rest.indexOf("@");
                    int j = rest.indexOf("\n");
                    if (i != -1) {
                        email.setUserName(rest.substring(0, i));
                        email.setHostName(rest.substring(i + 1));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return email;
    }

    public EmailField emailField() throws ParseException {
        try {
            this.lexer.match(101);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            EmailField emailField = new EmailField();
            EmailAddress emailAddress = new EmailAddress();
            String rest = this.lexer.getRest();
            String displayName = this.getDisplayName(rest.trim());
            emailAddress.setDisplayName(displayName);
            Email email = this.getEmail(rest);
            emailAddress.setEmail(email);
            emailField.setEmailAddress(emailAddress);
            return emailField;
        }
        catch (Exception e) {
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.emailField();
    }
}

