/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.text.ParseException;
import org.lastbamboo.common.sdp.Host;
import org.lastbamboo.common.sdp.HostNameParser;
import org.lastbamboo.common.sdp.Token;
import org.lastbamboo.common.sdp.fields.OriginField;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.SDPParser;

public class OriginFieldParser
extends SDPParser {
    public OriginFieldParser(String originField) {
        this.lexer = new Lexer("charLexer", originField);
    }

    public OriginField originField() throws ParseException {
        try {
            OriginField originField = new OriginField();
            this.lexer.match(111);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            this.lexer.match(4094);
            Token userName = this.lexer.getNextToken();
            originField.setUsername(userName.getTokenValue());
            this.lexer.SPorHT();
            this.lexer.match(4095);
            Token sessionId = this.lexer.getNextToken();
            originField.setSessId(Long.parseLong(sessionId.getTokenValue()));
            this.lexer.SPorHT();
            this.lexer.match(4095);
            Token sessionVersion = this.lexer.getNextToken();
            originField.setSessVersion(Long.parseLong(sessionVersion.getTokenValue()));
            this.lexer.SPorHT();
            this.lexer.match(4095);
            Token networkType = this.lexer.getNextToken();
            originField.setNettype(networkType.getTokenValue());
            this.lexer.SPorHT();
            this.lexer.match(4095);
            Token addressType = this.lexer.getNextToken();
            originField.setAddrtype(addressType.getTokenValue());
            this.lexer.SPorHT();
            String host = this.lexer.getRest();
            HostNameParser hostNameParser = new HostNameParser(host);
            Host h = hostNameParser.host();
            originField.setAddress(h);
            return originField;
        }
        catch (Exception e) {
            throw new ParseException(this.lexer.getBuffer(), this.lexer.getPtr());
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.originField();
    }

    public static void main(String[] args) throws ParseException {
        String[] origin = new String[]{"o=4855 13760799956958020 13760799956958020 IN IP4 166.35.224.216\r\n", "o=mh/andley 2890844526 2890842807 IN IP4 126.16.64.4\n", "o=UserB 2890844527 2890844527 IN IP4 everywhere.com\n", "o=UserA 2890844526 2890844526 IN IP4 here.com\n", "o=IFAXTERMINAL01 2890844527 2890844527 IN IP4 ift.here.com\n", "o=GATEWAY1 2890844527 2890844527 IN IP4 gatewayone.wcom.com\n", "o=- 2890844527 2890844527 IN IP4 gatewayone.wcom.com\n"};
        for (int i = 0; i < origin.length; ++i) {
            OriginFieldParser originFieldParser = new OriginFieldParser(origin[i]);
            OriginField originField = originFieldParser.originField();
            System.out.println("toParse :" + origin[i]);
            System.out.println("encoded: " + originField.encode());
        }
    }
}

