/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Hashtable;
import org.lastbamboo.common.sdp.InternalErrorHandler;
import org.lastbamboo.common.sdp.parser.AttributeFieldParser;
import org.lastbamboo.common.sdp.parser.BandwidthFieldParser;
import org.lastbamboo.common.sdp.parser.ConnectionFieldParser;
import org.lastbamboo.common.sdp.parser.EmailFieldParser;
import org.lastbamboo.common.sdp.parser.InformationFieldParser;
import org.lastbamboo.common.sdp.parser.KeyFieldParser;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.MediaFieldParser;
import org.lastbamboo.common.sdp.parser.OriginFieldParser;
import org.lastbamboo.common.sdp.parser.PhoneFieldParser;
import org.lastbamboo.common.sdp.parser.ProtoVersionFieldParser;
import org.lastbamboo.common.sdp.parser.RepeatFieldParser;
import org.lastbamboo.common.sdp.parser.SDPParser;
import org.lastbamboo.common.sdp.parser.SessionNameFieldParser;
import org.lastbamboo.common.sdp.parser.TimeFieldParser;
import org.lastbamboo.common.sdp.parser.URIFieldParser;
import org.lastbamboo.common.sdp.parser.ZoneFieldParser;

public class ParserFactory {
    private static Hashtable parserTable;
    private static Class[] constructorArgs;

    public static SDPParser createParser(String field) throws ParseException {
        String fieldName = Lexer.getFieldName(field);
        if (fieldName == null) {
            return null;
        }
        Class parserClass = (Class)parserTable.get(fieldName.toLowerCase());
        if (parserClass != null) {
            try {
                Constructor cons = parserClass.getConstructor(constructorArgs);
                Object[] args = new Object[]{field};
                SDPParser retval = (SDPParser)cons.newInstance(args);
                return retval;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return null;
            }
        }
        throw new ParseException("Could not find parser for " + fieldName, 0);
    }

    static {
        constructorArgs = new Class[1];
        ParserFactory.constructorArgs[0] = String.class;
        parserTable = new Hashtable();
        parserTable.put("a", AttributeFieldParser.class);
        parserTable.put("b", BandwidthFieldParser.class);
        parserTable.put("c", ConnectionFieldParser.class);
        parserTable.put("e", EmailFieldParser.class);
        parserTable.put("i", InformationFieldParser.class);
        parserTable.put("k", KeyFieldParser.class);
        parserTable.put("m", MediaFieldParser.class);
        parserTable.put("o", OriginFieldParser.class);
        parserTable.put("p", PhoneFieldParser.class);
        parserTable.put("v", ProtoVersionFieldParser.class);
        parserTable.put("r", RepeatFieldParser.class);
        parserTable.put("s", SessionNameFieldParser.class);
        parserTable.put("t", TimeFieldParser.class);
        parserTable.put("u", URIFieldParser.class);
        parserTable.put("z", ZoneFieldParser.class);
    }
}

