/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.text.ParseException;
import org.lastbamboo.common.sdp.Token;
import org.lastbamboo.common.sdp.fields.RepeatField;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.fields.TypedTime;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.SDPParser;

public class RepeatFieldParser
extends SDPParser {
    public RepeatFieldParser(String repeatField) {
        this.lexer = new Lexer("charLexer", repeatField);
    }

    public TypedTime getTypedTime(String tokenValue) {
        TypedTime typedTime = new TypedTime();
        if (tokenValue.endsWith("d")) {
            typedTime.setUnit("d");
            String t = tokenValue.replace('d', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else if (tokenValue.endsWith("h")) {
            typedTime.setUnit("h");
            String t = tokenValue.replace('h', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else if (tokenValue.endsWith("m")) {
            typedTime.setUnit("m");
            String t = tokenValue.replace('m', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else {
            typedTime.setUnit("s");
            if (tokenValue.endsWith("s")) {
                String t = tokenValue.replace('s', ' ');
                typedTime.setTime(Integer.parseInt(t.trim()));
            } else {
                typedTime.setTime(Integer.parseInt(tokenValue.trim()));
            }
        }
        return typedTime;
    }

    public RepeatField repeatField() throws ParseException {
        try {
            this.lexer.match(114);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            RepeatField repeatField = new RepeatField();
            this.lexer.match(4095);
            Token repeatInterval = this.lexer.getNextToken();
            this.lexer.SPorHT();
            TypedTime typedTime = this.getTypedTime(repeatInterval.getTokenValue());
            repeatField.setRepeatInterval(typedTime);
            this.lexer.match(4095);
            Token activeDuration = this.lexer.getNextToken();
            this.lexer.SPorHT();
            typedTime = this.getTypedTime(activeDuration.getTokenValue());
            repeatField.setActiveDuration(typedTime);
            while (this.lexer.lookAhead(0) != '\n') {
                this.lexer.match(4095);
                Token offsets = this.lexer.getNextToken();
                this.lexer.SPorHT();
                typedTime = this.getTypedTime(offsets.getTokenValue());
                repeatField.addOffset(typedTime);
            }
            return repeatField;
        }
        catch (Exception e) {
            throw this.lexer.createParseException();
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.repeatField();
    }
}

