/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.text.ParseException;
import java.util.Vector;
import org.lastbamboo.common.sdp.ParserCore;
import org.lastbamboo.common.sdp.SessionDescriptionImpl;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.ParserFactory;
import org.lastbamboo.common.sdp.parser.SDPParser;

public class SDPAnnounceParser
extends ParserCore {
    protected Lexer lexer;
    protected Vector sdpMessage;

    public SDPAnnounceParser(Vector sdpMessage) {
        this.sdpMessage = sdpMessage;
    }

    public SDPAnnounceParser(String message) {
        int start = 0;
        String line = null;
        if (message == null) {
            return;
        }
        this.sdpMessage = new Vector();
        String sdpAnnounce = message.trim() + "\r\n";
        while (start < sdpAnnounce.length()) {
            boolean add = false;
            int index = sdpAnnounce.indexOf("\n", start);
            int index2 = sdpAnnounce.indexOf("\r", start);
            if (index > 0 && index2 < 0) {
                line = sdpAnnounce.substring(start, index);
                start = index + 1;
            } else if (index < 0 && index2 > 0) {
                line = sdpAnnounce.substring(start, index2);
                start = index2 + 1;
            } else if (index > 0 && index2 > 0) {
                if (index > index2) {
                    line = sdpAnnounce.substring(start, index2);
                    start = index + 1;
                } else {
                    line = sdpAnnounce.substring(start, index);
                    start = index2 + 1;
                }
            } else if (index < 0 && index2 < 0) break;
            this.sdpMessage.addElement(line);
        }
    }

    public SessionDescriptionImpl parse() throws ParseException {
        SessionDescriptionImpl retval = new SessionDescriptionImpl();
        for (int i = 0; i < this.sdpMessage.size(); ++i) {
            String field = (String)this.sdpMessage.elementAt(i);
            SDPParser sdpParser = ParserFactory.createParser(field);
            SDPField sdpField = sdpParser.parse();
            retval.addField(sdpField);
        }
        return retval;
    }

    public static void main(String[] args) throws Exception {
        String sdpData = "\r\n    v=0\r\no=4855 13760799956958020 13760799956958020 IN IP4  129.6.55.78\r\ns=mysession session\r\np=+46 8 52018010\r\nc=IN IP4  129.6.55.78\r\nt=0 0\r\nm=audio 6022 RTP/AVP 0 4 18\r\na=rtpmap:0 PCMU/8000\r\na=rtpmap:4 G723/8000\r\na=rtpmap:18 G729A/8000\r\na=ptime:20\r\n";
        SDPAnnounceParser parser = new SDPAnnounceParser(sdpData);
        SessionDescriptionImpl sessiondescription = parser.parse();
        System.out.println("Encoded structure = " + sessiondescription.toString());
    }
}

