/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.text.ParseException;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.fields.TimeField;
import org.lastbamboo.common.sdp.fields.TypedTime;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.SDPParser;

public class TimeFieldParser
extends SDPParser {
    public TimeFieldParser(String timeField) {
        this.lexer = new Lexer("charLexer", timeField);
    }

    public TypedTime getTypedTime(String tokenValue) {
        TypedTime typedTime = new TypedTime();
        if (tokenValue.endsWith("d")) {
            typedTime.setUnit("d");
            String t = tokenValue.replace('d', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else if (tokenValue.endsWith("h")) {
            typedTime.setUnit("h");
            String t = tokenValue.replace('h', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else if (tokenValue.endsWith("m")) {
            typedTime.setUnit("m");
            String t = tokenValue.replace('m', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else {
            typedTime.setUnit("s");
            if (tokenValue.endsWith("s")) {
                String t = tokenValue.replace('s', ' ');
                typedTime.setTime(Integer.parseInt(t.trim()));
            } else {
                typedTime.setTime(Integer.parseInt(tokenValue.trim()));
            }
        }
        return typedTime;
    }

    private long getTime() throws ParseException {
        try {
            String startTime = this.lexer.number();
            return Long.parseLong(startTime);
        }
        catch (NumberFormatException ex) {
            throw this.lexer.createParseException();
        }
    }

    public TimeField timeField() throws ParseException {
        try {
            this.lexer.match(116);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            TimeField timeField = new TimeField();
            long st = this.getTime();
            timeField.setStartTime(st);
            this.lexer.SPorHT();
            st = this.getTime();
            timeField.setStopTime(st);
            return timeField;
        }
        catch (Exception e) {
            throw this.lexer.createParseException();
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.timeField();
    }
}

