/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sdp.parser;

import java.text.ParseException;
import org.lastbamboo.common.sdp.Token;
import org.lastbamboo.common.sdp.fields.SDPField;
import org.lastbamboo.common.sdp.fields.TypedTime;
import org.lastbamboo.common.sdp.fields.ZoneAdjustment;
import org.lastbamboo.common.sdp.fields.ZoneField;
import org.lastbamboo.common.sdp.parser.Lexer;
import org.lastbamboo.common.sdp.parser.SDPParser;

public class ZoneFieldParser
extends SDPParser {
    public ZoneFieldParser(String zoneField) {
        this.lexer = new Lexer("charLexer", zoneField);
    }

    public String getSign(String tokenValue) {
        if (tokenValue.startsWith("-")) {
            return "-";
        }
        return "+";
    }

    public TypedTime getTypedTime(String tokenValue) {
        TypedTime typedTime = new TypedTime();
        String offset = null;
        offset = tokenValue.startsWith("-") ? tokenValue.replace('-', ' ') : (tokenValue.startsWith("+") ? tokenValue.replace('+', ' ') : tokenValue);
        if (offset.endsWith("d")) {
            typedTime.setUnit("d");
            String t = offset.replace('d', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else if (offset.endsWith("h")) {
            typedTime.setUnit("h");
            String t = offset.replace('h', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else if (offset.endsWith("m")) {
            typedTime.setUnit("m");
            String t = offset.replace('m', ' ');
            typedTime.setTime(Integer.parseInt(t.trim()));
        } else {
            typedTime.setUnit("s");
            if (offset.endsWith("s")) {
                String t = offset.replace('s', ' ');
                typedTime.setTime(Integer.parseInt(t.trim()));
            } else {
                typedTime.setTime(Integer.parseInt(offset.trim()));
            }
        }
        return typedTime;
    }

    public ZoneField zoneField() throws ParseException {
        try {
            ZoneField zoneField = new ZoneField();
            this.lexer.match(122);
            this.lexer.SPorHT();
            this.lexer.match(61);
            this.lexer.SPorHT();
            while (this.lexer.lookAhead(0) != '\n') {
                ZoneAdjustment zoneAdjustment = new ZoneAdjustment();
                this.lexer.match(4095);
                Token time = this.lexer.getNextToken();
                this.lexer.SPorHT();
                zoneAdjustment.setTime(Long.parseLong(time.getTokenValue()));
                this.lexer.match(4095);
                Token offset = this.lexer.getNextToken();
                this.lexer.SPorHT();
                String sign = this.getSign(offset.getTokenValue());
                TypedTime typedTime = this.getTypedTime(offset.getTokenValue());
                zoneAdjustment.setSign(sign);
                zoneAdjustment.setOffset(typedTime);
                zoneField.addZoneAdjustment(zoneAdjustment);
            }
            return zoneField;
        }
        catch (Exception e) {
            throw this.lexer.createParseException();
        }
    }

    @Override
    public SDPField parse() throws ParseException {
        return this.zoneField();
    }
}

