/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.bootstrap;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.lastbamboo.common.offer.answer.OfferAnswerFactory;
import org.lastbamboo.common.sip.bootstrap.ProxyRegistrar;
import org.lastbamboo.common.sip.client.CrlfDelayCalculator;
import org.lastbamboo.common.sip.client.DefaultCrlfDelayCalculator;
import org.lastbamboo.common.sip.client.SipClient;
import org.lastbamboo.common.sip.client.SipClientCloseListener;
import org.lastbamboo.common.sip.client.SipClientImpl;
import org.lastbamboo.common.sip.client.SipClientTracker;
import org.lastbamboo.common.sip.client.util.ProxyRegistrationListener;
import org.lastbamboo.common.sip.stack.IdleSipSessionListener;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.transaction.client.SipTransactionTracker;
import org.lastbamboo.common.sip.stack.transport.SipTcpTransportLayer;
import org.lastbamboo.common.sip.stack.util.UriUtils;
import org.littleshoot.util.SessionSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyRegistrarImpl
implements ProxyRegistrar {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final URI m_client;
    private final URI m_proxy;
    private final ProxyRegistrationListener m_listener;
    private final SipMessageFactory m_messageFactory;
    private final SipClientTracker m_sipClientTracker;
    private final UriUtils m_uriUtils;
    private final SipTransactionTracker m_transactionTracker;
    private final SipTcpTransportLayer m_transportLayer;
    private final OfferAnswerFactory m_offerAnswerFactory;
    private final IdleSipSessionListener m_idleSipSessionListener;
    private final SessionSocketListener callSocketListener;
    private final InetSocketAddress serverAddress;

    public ProxyRegistrarImpl(UriUtils uriUtils, URI client, URI proxy, ProxyRegistrationListener listener, SipMessageFactory messageFactory, SipTcpTransportLayer transportLayer, SipTransactionTracker transactionTracker, OfferAnswerFactory offerAnswerFactory, InetSocketAddress serverAddress, SessionSocketListener callSocketListener, SipClientTracker clientTracker, IdleSipSessionListener idleSipSessionListener) {
        this.m_client = client;
        this.m_proxy = proxy;
        this.m_listener = listener;
        this.m_uriUtils = uriUtils;
        this.m_messageFactory = messageFactory;
        this.m_offerAnswerFactory = offerAnswerFactory;
        this.serverAddress = serverAddress;
        this.callSocketListener = callSocketListener;
        this.m_sipClientTracker = clientTracker;
        this.m_transactionTracker = transactionTracker;
        this.m_transportLayer = transportLayer;
        this.m_idleSipSessionListener = idleSipSessionListener;
    }

    @Override
    public void register() {
        DefaultCrlfDelayCalculator calculator = new DefaultCrlfDelayCalculator();
        try {
            SipClientImpl client = new SipClientImpl(this.m_client, this.m_proxy, this.m_messageFactory, this.m_transactionTracker, this.m_offerAnswerFactory, this.serverAddress, this.callSocketListener, this.m_uriUtils, this.m_transportLayer, (SipClientCloseListener)this.m_sipClientTracker, (CrlfDelayCalculator)calculator, this.m_idleSipSessionListener);
            client.connect();
            client.register();
            this.LOG.debug("Adding SIP client!!");
            this.m_sipClientTracker.addSipClient((SipClient)client, this.m_listener);
            this.m_listener.registered(this.m_client, this.m_proxy);
        }
        catch (IOException e) {
            this.LOG.debug("Could not register!!", (Throwable)e);
            this.m_listener.registrationFailed(this.m_client, this.m_proxy);
        }
    }
}

