/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.bootstrap;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.lastbamboo.common.sip.bootstrap.ProxyRegistrar;
import org.lastbamboo.common.sip.bootstrap.ProxyRegistrarFactory;
import org.lastbamboo.common.sip.client.util.ProxyRegistrationListener;
import org.littleshoot.util.ConnectionEstablisher;
import org.littleshoot.util.ConnectionMaintainerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegistrarConnectionEstablisher
implements ConnectionEstablisher<URI, URI> {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final URI m_client;
    private final ProxyRegistrarFactory m_registrarFactory;
    private final ProxyRegistrationListener m_listener;
    private final Map<URI, ConnectionMaintainerListener<URI>> m_connectionMaintainerListeners;
    private final ProxyRegistrationListener m_myListener;

    public RegistrarConnectionEstablisher(URI client, ProxyRegistrarFactory registrarFactory, ProxyRegistrationListener listener) {
        this.m_client = client;
        this.m_registrarFactory = registrarFactory;
        this.m_listener = listener;
        this.m_connectionMaintainerListeners = new HashMap<URI, ConnectionMaintainerListener<URI>>();
        this.m_myListener = new MyListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNotifying(URI registrar, ConnectionMaintainerListener<URI> listener) {
        Map<URI, ConnectionMaintainerListener<URI>> map = this.m_connectionMaintainerListeners;
        synchronized (map) {
            this.m_connectionMaintainerListeners.put(registrar, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopNotifying(URI registrar) {
        Map<URI, ConnectionMaintainerListener<URI>> map = this.m_connectionMaintainerListeners;
        synchronized (map) {
            this.m_connectionMaintainerListeners.remove(registrar);
        }
    }

    private ConnectionMaintainerListener<URI> getConnectionMaintainerListener(URI registrar) {
        return this.m_connectionMaintainerListeners.get(registrar);
    }

    public void establish(URI serverId, ConnectionMaintainerListener<URI> listener) {
        this.LOG.debug("Registering with: " + serverId);
        this.startNotifying(serverId, listener);
        try {
            ProxyRegistrar registrar = this.m_registrarFactory.getRegistrar(this.m_client, serverId, this.m_myListener);
            registrar.register();
        }
        catch (RuntimeException e) {
            this.LOG.warn("Could not either access the registrar or register", (Throwable)e);
            this.stopNotifying(serverId);
            throw e;
        }
    }

    private class MyListener
    implements ProxyRegistrationListener {
        private MyListener() {
        }

        public void registered(URI client, URI proxy) {
            ConnectionMaintainerListener connectionMaintainerListener = RegistrarConnectionEstablisher.this.getConnectionMaintainerListener(proxy);
            connectionMaintainerListener.connected((Object)proxy);
            RegistrarConnectionEstablisher.this.m_listener.registered(client, proxy);
        }

        public void reRegistered(URI client, URI proxy) {
            ConnectionMaintainerListener connectionMaintainerListener = RegistrarConnectionEstablisher.this.getConnectionMaintainerListener(proxy);
            connectionMaintainerListener.reconnected();
            RegistrarConnectionEstablisher.this.m_listener.reRegistered(client, proxy);
        }

        public void registrationFailed(URI client, URI proxy) {
            ConnectionMaintainerListener connectionMaintainerListener = RegistrarConnectionEstablisher.this.getConnectionMaintainerListener(proxy);
            connectionMaintainerListener.connectionFailed();
            RegistrarConnectionEstablisher.this.stopNotifying(proxy);
            RegistrarConnectionEstablisher.this.m_listener.registrationFailed(client, proxy);
        }

        public void unregistered(URI client, URI proxy) {
            ConnectionMaintainerListener connectionMaintainerListener = RegistrarConnectionEstablisher.this.getConnectionMaintainerListener(proxy);
            connectionMaintainerListener.disconnected();
            RegistrarConnectionEstablisher.this.stopNotifying(proxy);
            RegistrarConnectionEstablisher.this.m_listener.unregistered(client, proxy);
        }
    }
}

