/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.bootstrap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.lastbamboo.common.sip.bootstrap.ProxyRegistrar;
import org.lastbamboo.common.sip.bootstrap.ProxyRegistrarFactory;
import org.lastbamboo.common.sip.bootstrap.RobustProxyRegistrarFactory;
import org.lastbamboo.common.sip.bootstrap.RobustProxyRegistrarImpl;
import org.lastbamboo.common.sip.client.util.ProxyRegistrationListener;
import org.lastbamboo.common.sip.stack.util.UriUtils;
import org.littleshoot.util.CandidateProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RobustProxyRegistrarFactoryImpl
implements RobustProxyRegistrarFactory {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_TRANSPORT = "tcp";
    private final UriUtils m_uriUtils;
    private final CandidateProvider<URI> m_candidateProvider;
    private final ProxyRegistrarFactory m_registrarFactory;

    public RobustProxyRegistrarFactoryImpl(UriUtils uriUtils, final CandidateProvider<InetSocketAddress> sipCandidateProvider, ProxyRegistrarFactory registrarFactory) {
        this.m_uriUtils = uriUtils;
        this.m_candidateProvider = new CandidateProvider<URI>(){

            public URI getCandidate() {
                Collection<URI> candidates = this.getCandidates();
                if (candidates.isEmpty()) {
                    return null;
                }
                return candidates.iterator().next();
            }

            public Collection<URI> getCandidates() {
                RobustProxyRegistrarFactoryImpl.this.m_log.debug("Accessing SIP servers...");
                LinkedList<URI> candidates = new LinkedList<URI>();
                Collection addresses = sipCandidateProvider.getCandidates();
                RobustProxyRegistrarFactoryImpl.this.m_log.info("Connecting to servers: {}", (Object)addresses);
                for (InetSocketAddress isa : addresses) {
                    RobustProxyRegistrarFactoryImpl.this.m_log.info("Processing candidate address: {}", (Object)isa);
                    InetAddress address = isa.getAddress();
                    String host = address.getHostAddress();
                    URI uri = RobustProxyRegistrarFactoryImpl.this.m_uriUtils.getSipUri(host, isa.getPort(), RobustProxyRegistrarFactoryImpl.DEFAULT_TRANSPORT);
                    candidates.add(uri);
                }
                return candidates;
            }
        };
        this.m_registrarFactory = registrarFactory;
    }

    @Override
    public ProxyRegistrar getRegistrar(URI client, ProxyRegistrationListener listener) {
        return new RobustProxyRegistrarImpl(client, this.m_candidateProvider, this.m_registrarFactory, listener);
    }
}

