/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.bootstrap;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import org.lastbamboo.common.offer.answer.IceMediaStreamDesc;
import org.lastbamboo.common.offer.answer.NoAnswerException;
import org.lastbamboo.common.offer.answer.OfferAnswerFactory;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.offer.answer.Offerer;
import org.lastbamboo.common.p2p.DefaultTcpUdpSocket;
import org.lastbamboo.common.p2p.P2PClient;
import org.lastbamboo.common.p2p.P2PConnectionListener;
import org.lastbamboo.common.sip.bootstrap.ProxyRegistrar;
import org.lastbamboo.common.sip.bootstrap.RobustProxyRegistrarFactory;
import org.lastbamboo.common.sip.client.SipClient;
import org.lastbamboo.common.sip.client.SipClientTracker;
import org.lastbamboo.common.sip.client.util.ProxyRegistrationListener;
import org.lastbamboo.common.sip.stack.SipUriFactory;
import org.littleshoot.util.KeyStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SipClientLauncher
implements P2PClient {
    private static final Logger LOG = LoggerFactory.getLogger(SipClientLauncher.class);
    private final RobustProxyRegistrarFactory m_registrarFactory;
    private final SipClientTracker m_sipClientTracker;
    private final OfferAnswerFactory m_offerAnswerFactory;
    private final int m_relayWaitTime;
    private volatile boolean loggedIn;

    public SipClientLauncher(SipClientTracker sipClientTracker, RobustProxyRegistrarFactory registrarFactory, OfferAnswerFactory offerAnswerFactory, int relayWaitTime) {
        this.m_sipClientTracker = sipClientTracker;
        this.m_registrarFactory = registrarFactory;
        this.m_offerAnswerFactory = offerAnswerFactory;
        this.m_relayWaitTime = relayWaitTime;
    }

    public String login(String user, String password) {
        LOG.debug("Registering...");
        URI sipUri = SipUriFactory.createSipUri((String)user);
        this.register(sipUri);
        this.loggedIn = true;
        return sipUri.toASCIIString();
    }

    public String login(String user, String password, String id) throws IOException {
        return this.login(user, password);
    }

    private void register(URI sipUri) {
        if (this.loggedIn) {
            LOG.info("Already logged in -- not logging in again.");
            return;
        }
        ProxyRegistrar registrar = this.m_registrarFactory.getRegistrar(sipUri, new NoOpRegistrationListener());
        registrar.register();
    }

    public void offer(URI uri, byte[] offer, OfferAnswerTransactionListener transactionListener, KeyStorage keyStore) throws IOException {
        LOG.error("Offer not supported");
        throw new UnsupportedOperationException("Offer not supported");
    }

    public Socket newSocket(URI sipUri) throws IOException, NoAnswerException {
        LOG.trace("Creating SIP socket for URI: {}", (Object)sipUri);
        SipClient client = this.m_sipClientTracker.getSipClient();
        if (client == null) {
            LOG.warn("No available SIP clients!!");
            throw new IOException("No available connections to SIP proxies!!");
        }
        IceMediaStreamDesc stream = IceMediaStreamDesc.newReliable();
        DefaultTcpUdpSocket tcpUdpSocket = new DefaultTcpUdpSocket((Offerer)client, this.m_offerAnswerFactory, this.m_relayWaitTime, stream);
        return (Socket)tcpUdpSocket.newSocket(sipUri);
    }

    public Socket newUnreliableSocket(URI sipUri) throws IOException, NoAnswerException {
        LOG.trace("Creating SIP socket for URI: {}", (Object)sipUri);
        SipClient client = this.m_sipClientTracker.getSipClient();
        if (client == null) {
            LOG.warn("No available SIP clients!!");
            throw new IOException("No available connections to SIP proxies!!");
        }
        IceMediaStreamDesc desc = new IceMediaStreamDesc(true, true, "application", "udp", 1, true, true);
        DefaultTcpUdpSocket tcpUdpSocket = new DefaultTcpUdpSocket((Offerer)client, this.m_offerAnswerFactory, this.m_relayWaitTime, desc);
        return (Socket)tcpUdpSocket.newSocket(sipUri);
    }

    public Socket newRawSocket(URI uri) throws IOException, NoAnswerException {
        return this.newSocket(uri);
    }

    public Socket newRawUnreliableSocket(URI uri) throws IOException, NoAnswerException {
        return this.newUnreliableSocket(uri);
    }

    public void logout() {
    }

    public void addConnectionListener(P2PConnectionListener listener) {
    }

    private static final class NoOpRegistrationListener
    implements ProxyRegistrationListener {
        private NoOpRegistrationListener() {
        }

        public void reRegistered(URI client, URI proxy) {
            LOG.debug("Got re-registered");
        }

        public void registered(URI client, URI proxy) {
            LOG.debug("Got registered");
        }

        public void registrationFailed(URI client, URI proxy) {
            LOG.debug("Got registration failed.");
        }

        public void unregistered(URI client, URI proxy) {
            LOG.debug("Got unregistered");
        }
    }
}

