/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.prefs.Preferences;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.IOExceptionWithCause;
import org.lastbamboo.common.offer.answer.NoAnswerException;
import org.lastbamboo.common.p2p.SocketFactory;
import org.lastbamboo.common.sip.stack.SipUriFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SipProtocolSocketFactory
implements ProtocolSocketFactory {
    private final Logger m_log = LoggerFactory.getLogger(SipProtocolSocketFactory.class);
    private final SocketFactory<Socket> m_sipSocketFactory;

    public SipProtocolSocketFactory(SocketFactory<Socket> sipSocketFactory) {
        this.m_sipSocketFactory = sipSocketFactory;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) {
        this.m_log.warn("Attempted unsupported socket call");
        throw new UnsupportedOperationException("not allowed");
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        this.m_log.trace("Creating a socket for user: {}", (Object)host);
        return this.createSocket(host, port);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        this.m_log.trace("Creating a socket for user: {}", (Object)host);
        Preferences prefs = Preferences.userRoot();
        long id = prefs.getLong("LITTLESHOOT_ID", -1L);
        if (id == Long.parseLong(host)) {
            this.m_log.error("Ignoring request to download from ourselves...");
            throw new IOException("Not downloading from ourselves...");
        }
        URI sipUri = SipUriFactory.createSipUri((String)host);
        try {
            this.m_log.trace("About to create socket...");
            Socket sock = (Socket)this.m_sipSocketFactory.newSocket(sipUri);
            this.m_log.debug("Got socket!! Returning to HttpClient");
            return sock;
        }
        catch (NoAnswerException e) {
            this.m_log.warn("No answer!!", (Throwable)e);
            throw new IOExceptionWithCause((Throwable)e);
        }
        catch (IOException e) {
            this.m_log.warn("Exception creating SIP socket", (Throwable)e);
            throw e;
        }
    }
}

