/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.lastbamboo.common.sip.proxy.LocationService;
import org.lastbamboo.common.sip.stack.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LastBambooLocationService
implements LocationService {
    private final Logger LOG = LoggerFactory.getLogger(LastBambooLocationService.class);
    private final UriUtils m_uriUtils;

    public LastBambooLocationService(UriUtils uriUtils) {
        this.m_uriUtils = uriUtils;
    }

    @Override
    public boolean canHandle(URI requestUri) {
        this.LOG.debug("requestUri: " + requestUri);
        return this.hasDomain(this.m_uriUtils.getHostInSipUri(requestUri));
    }

    @Override
    public Collection getTargetSet(URI requestUri) {
        int personId = this.m_uriUtils.getPersonIdInSipUri(requestUri);
        LinkedList targetSet = new LinkedList();
        return targetSet;
    }

    private boolean hasDomain(String hostInSipUri) {
        return hostInSipUri.equalsIgnoreCase("lastbamboo.org");
    }
}

