/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy;

import java.net.URI;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.lastbamboo.common.sip.proxy.CanHandleRequestPredicate;
import org.lastbamboo.common.sip.proxy.LocationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocationServiceChain
implements LocationService {
    private final Logger LOG = LoggerFactory.getLogger(LocationServiceChain.class);
    private final Collection m_services;

    public LocationServiceChain(Collection services) {
        this.m_services = services;
    }

    @Override
    public boolean canHandle(URI requestUri) {
        CanHandleRequestPredicate predicate = new CanHandleRequestPredicate(requestUri);
        return CollectionUtils.exists((Collection)this.m_services, (Predicate)predicate);
    }

    @Override
    public Collection getTargetSet(URI requestUri) {
        CanHandleRequestPredicate predicate = new CanHandleRequestPredicate(requestUri);
        LocationService service = (LocationService)CollectionUtils.find((Collection)this.m_services, (Predicate)predicate);
        return service.getTargetSet(requestUri);
    }
}

