/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.lastbamboo.common.sip.proxy.SipProxy;
import org.lastbamboo.common.sip.proxy.SipProxyImplMBean;
import org.lastbamboo.common.sip.proxy.SipProxyMessageVisitorFactory;
import org.lastbamboo.common.sip.proxy.SipRegistrar;
import org.lastbamboo.common.sip.proxy.SipRequestAndResponseForwarder;
import org.lastbamboo.common.sip.stack.codec.SipIoHandler;
import org.lastbamboo.common.sip.stack.codec.SipProtocolCodecFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageVisitorFactory;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactory;
import org.lastbamboo.common.sip.stack.transport.SipTcpTransportLayer;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.util.JmxUtils;
import org.littleshoot.util.RuntimeIoException;
import org.littleshoot.util.mina.MinaTcpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipProxyImpl
implements SipProxy,
IoServiceListener,
SipProxyImplMBean {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final SipMessageFactory m_sipMessageFactory;
    private final SipRequestAndResponseForwarder m_forwarder;
    private final SipRegistrar m_registrar;
    private final SipTcpTransportLayer m_transportLayer;
    private final SipHeaderFactory m_sipHeaderFactory;
    private final MinaTcpServer m_minaServer;
    private final AtomicBoolean m_serviceActivated = new AtomicBoolean(false);

    public SipProxyImpl(SipRequestAndResponseForwarder forwarder, SipRegistrar registrar, SipHeaderFactory sipHeaderFactory, SipMessageFactory sipMessageFactory, SipTcpTransportLayer transportLayer) {
        this.m_forwarder = forwarder;
        this.m_registrar = registrar;
        this.m_sipHeaderFactory = sipHeaderFactory;
        this.m_sipMessageFactory = sipMessageFactory;
        this.m_transportLayer = transportLayer;
        this.m_log.debug("Starting server on: 5061");
        SipProtocolCodecFactory codecFactory = new SipProtocolCodecFactory(this.m_sipHeaderFactory);
        SipProxyMessageVisitorFactory visitorFactory = new SipProxyMessageVisitorFactory(this.m_forwarder, this.m_registrar, this.m_sipMessageFactory);
        SipIoHandler handler = new SipIoHandler((SipMessageVisitorFactory)visitorFactory);
        this.m_minaServer = new MinaTcpServer((ProtocolCodecFactory)codecFactory, (IoServiceListener)this, (IoHandler)handler, "SIP-Proxy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.m_log.debug("Starting MINA server...");
        this.m_minaServer.start(5061);
        AtomicBoolean atomicBoolean = this.m_serviceActivated;
        synchronized (atomicBoolean) {
            if (!this.m_serviceActivated.get()) {
                try {
                    this.m_serviceActivated.wait(6000L);
                }
                catch (InterruptedException e) {
                    this.m_log.error("Interrupted??", (Throwable)e);
                }
            }
        }
        if (!this.m_serviceActivated.get()) {
            this.m_log.error("Server not started!!");
            throw new RuntimeIoException("Could not start SIP server");
        }
        this.m_log.debug("Started server...");
    }

    public void sessionCreated(IoSession session) {
        this.m_transportLayer.addConnection(session);
    }

    public void sessionDestroyed(IoSession session) {
        this.m_log.debug("Session was destroyed: {}", (Object)session);
        this.m_registrar.sessionClosed(session);
        this.m_transportLayer.removeConnection(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.m_log.debug("Service activated on: {}", (Object)serviceAddress);
        this.m_serviceActivated.set(true);
        AtomicBoolean atomicBoolean = this.m_serviceActivated;
        synchronized (atomicBoolean) {
            this.m_serviceActivated.notify();
        }
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.m_log.debug("Service deactivated on: " + serviceAddress);
    }

    private void startJmxServer() {
        this.m_log.debug("Starting JMX server on: {}", (Object)System.getProperty("com.sun.management.jmxremote.port"));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JmxUtils.register((MBeanServer)mbs, (Object)this.m_registrar);
        JmxUtils.register((MBeanServer)mbs, (Object)this);
    }

    @Override
    public int getSipPort() {
        return 5061;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

