/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.lastbamboo.common.sip.proxy.SipRegistrar;
import org.lastbamboo.common.sip.proxy.SipRequestAndResponseForwarder;
import org.lastbamboo.common.sip.stack.message.DoubleCrlfKeepAlive;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.Register;
import org.lastbamboo.common.sip.stack.message.RequestTimeoutResponse;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageVisitor;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.UnknownSipRequest;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipProxyMessageVisitor
implements SipMessageVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(SipProxyMessageVisitor.class);
    private final SipRequestAndResponseForwarder m_forwarder;
    private final SipRegistrar m_registrar;
    private final SipMessageFactory m_messageFactory;
    private final IoSession m_ioSession;
    private static volatile int s_registersVisited = 0;
    private static volatile int s_invitesVisited = 0;
    private static volatile int s_responsesVisited = 0;

    public SipProxyMessageVisitor(SipRequestAndResponseForwarder forwarder, SipRegistrar registrar, SipMessageFactory messageFactory, IoSession session) {
        this.m_forwarder = forwarder;
        this.m_registrar = registrar;
        this.m_messageFactory = messageFactory;
        this.m_ioSession = session;
    }

    public void visitResponse(SipResponse response) {
        ++s_responsesVisited;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Now visited " + s_responsesVisited + " responses");
        }
        try {
            this.m_forwarder.forwardSipResponse(response);
        }
        catch (IOException e) {
            LOG.error("Could not process response", (Throwable)e);
        }
    }

    public void visitInvite(Invite invite) {
        Invite inviteToForward;
        SipHeader via;
        ++s_invitesVisited;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Now visited " + s_invitesVisited + " invites");
        }
        if ((via = invite.getHeader("Via")) == null) {
            LOG.warn("No Via header in INVITE: " + invite);
            return;
        }
        InetSocketAddress remoteSocketAddress = (InetSocketAddress)this.m_ioSession.getRemoteAddress();
        try {
            inviteToForward = this.m_messageFactory.createInviteToForward(remoteSocketAddress, invite);
        }
        catch (IOException e) {
            LOG.warn("Could not create INVITE to forward..");
            return;
        }
        if (inviteToForward == null) {
            return;
        }
        this.m_forwarder.forwardSipRequest(inviteToForward);
    }

    public void visitRegister(Register register) {
        ++s_registersVisited;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Now visited " + s_registersVisited + " registers");
        }
        this.m_registrar.handleRegister(register, this.m_ioSession);
    }

    public void visitDoubleCrlfKeepAlive(DoubleCrlfKeepAlive keepAlive) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Visiting double CRLF from: {}", (Object)this.m_ioSession.getRemoteAddress());
        }
    }

    public void visitRequestTimedOut(RequestTimeoutResponse response) {
        LOG.warn("Received request timed out on the proxy: " + response);
    }

    public void visitUnknownRequest(UnknownSipRequest request) {
        LOG.warn("Visiting and ignoring unknown request: " + request);
    }
}

