/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.NotificationBroadcasterSupport;
import org.lastbamboo.common.sip.proxy.RegistrationListener;
import org.lastbamboo.common.sip.proxy.SipRegistrar;
import org.lastbamboo.common.sip.proxy.SipRegistrarImplMBean;
import org.lastbamboo.common.sip.stack.message.Register;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.transport.SipTcpTransportLayer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.util.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipRegistrarImpl
extends NotificationBroadcasterSupport
implements SipRegistrar,
SipRegistrarImplMBean {
    private final Logger m_log = LoggerFactory.getLogger(SipRegistrarImpl.class);
    private final SipMessageFactory m_messageFactory;
    private final SipTcpTransportLayer m_transportLayer;
    private final Map<URI, IoSession> m_registrations = new ConcurrentHashMap<URI, IoSession>();
    private final Collection<RegistrationListener> m_registrationListeners = new LinkedList<RegistrationListener>();
    private int m_maxSize = 0;

    public SipRegistrarImpl(SipMessageFactory factory, SipTcpTransportLayer transportLayer) {
        this.m_messageFactory = factory;
        this.m_transportLayer = transportLayer;
    }

    @Override
    public void handleRegister(Register register, IoSession session) {
        this.m_log.debug("Processing registration...");
        SipHeader fromHeader = register.getHeader("From");
        URI uri = SipMessageUtils.extractUri((SipHeader)fromHeader);
        if (this.m_registrations.containsKey(uri)) {
            IoSession existingSession = this.m_registrations.get(uri);
            this.m_log.warn("We already have a registration for URI: " + uri + " with value: " + existingSession + "...closing");
            existingSession.close();
        }
        this.m_registrations.put(uri, session);
        if (this.m_registrations.size() > this.m_maxSize) {
            this.m_maxSize = this.m_registrations.size();
            this.m_log.debug("New maximum registrations this session: {}", (Object)this.m_maxSize);
        }
        SipResponse response = this.m_messageFactory.createRegisterOk(register);
        InetSocketAddress remoteAddress = (InetSocketAddress)session.getRemoteAddress();
        this.m_log.debug("Writing OK response to SIP client...");
        this.m_transportLayer.writeResponse(remoteAddress, response);
        this.notifyListeners(uri, true);
    }

    @Override
    public IoSession getIoSession(URI uri) {
        return this.m_registrations.get(uri);
    }

    @Override
    public boolean hasRegistration(URI uri) {
        return this.m_registrations.containsKey(uri);
    }

    @Override
    public void sessionClosed(IoSession session) {
        URI uri = (URI)MapUtils.removeFromMapValues(this.m_registrations, (Object)session);
        if (uri != null) {
            this.notifyListeners(uri, false);
        } else {
            this.m_log.warn("Could not locate URI for reader/writer: " + session + " in:\n" + this.m_registrations.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(URI uri, boolean registered) {
        Collection<RegistrationListener> collection = this.m_registrationListeners;
        synchronized (collection) {
            for (RegistrationListener rl : this.m_registrationListeners) {
                if (registered) {
                    rl.onRegistered(uri);
                    continue;
                }
                rl.onUnregistered(uri);
            }
        }
    }

    @Override
    public void addRegistrationListener(RegistrationListener listener) {
        this.m_log.debug("Adding registration listener...");
        this.m_registrationListeners.add(listener);
    }

    @Override
    public int getSipNumRegistered() {
        return this.m_registrations.size();
    }

    @Override
    public int getSipMaxRegistered() {
        return this.m_maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URI> getRegistered() {
        HashSet<URI> registered = new HashSet<URI>();
        Map<URI, IoSession> map = this.m_registrations;
        synchronized (map) {
            Set<URI> keySet = this.m_registrations.keySet();
            registered.addAll(keySet);
        }
        return registered;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

