/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy.stateless;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.lastbamboo.common.sip.proxy.SipRegistrar;
import org.lastbamboo.common.sip.proxy.SipRequestAndResponseForwarder;
import org.lastbamboo.common.sip.proxy.SipRequestForwarder;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.transport.SipTcpTransportLayer;
import org.lastbamboo.common.sip.stack.util.UriUtils;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatelessSipProxy
implements SipRequestAndResponseForwarder {
    private final Logger LOG = LoggerFactory.getLogger(StatelessSipProxy.class);
    private final SipRegistrar m_registrar;
    private final SipRequestForwarder m_unregisteredUriForwarder;
    private final SipRequestForwarder m_externalDomainForwarder;
    private final UriUtils m_uriUtils;
    private final SipTcpTransportLayer m_transportLayer;
    private final SipMessageFactory m_messageFactory;

    public StatelessSipProxy(SipTcpTransportLayer transportLayer, SipRegistrar registrar, SipRequestForwarder unregisteredUriForwarder, SipRequestForwarder externalDomainForwarder, UriUtils uriUtils, SipMessageFactory messageFactory) {
        this.m_transportLayer = transportLayer;
        this.m_registrar = registrar;
        this.m_unregisteredUriForwarder = unregisteredUriForwarder;
        this.m_externalDomainForwarder = externalDomainForwarder;
        this.m_uriUtils = uriUtils;
        this.m_messageFactory = messageFactory;
    }

    @Override
    public void forwardSipRequest(Invite request) {
        URI uri;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Processing request...");
        }
        try {
            uri = SipMessageUtils.extractUriFromRequestLine((SipMessage)request);
        }
        catch (IOException e) {
            this.LOG.warn("Could not extract URI from request: " + request);
            return;
        }
        String host = this.m_uriUtils.getHostInSipUri(uri);
        if (host.equalsIgnoreCase("lastbamboo.org")) {
            if (this.m_registrar.hasRegistration(uri)) {
                IoSession io = this.m_registrar.getIoSession(uri);
                if (io == null) {
                    this.LOG.debug("Forwarding request for user not registered with this proxy...");
                    this.m_unregisteredUriForwarder.forwardSipRequest(request);
                } else {
                    this.LOG.debug("Forwarding message for client we have...");
                    this.m_transportLayer.writeRequestStatelessly(request, io);
                }
            } else {
                this.LOG.debug("Forwarding request for user not registered with this proxy...");
            }
        } else {
            this.LOG.debug("Forwarding request for external domain: " + host);
            this.m_externalDomainForwarder.forwardSipRequest(request);
        }
    }

    @Override
    public void forwardSipResponse(SipResponse originalResponse) throws IOException {
        SipHeader header;
        List values;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Forwarding original response: " + originalResponse);
        }
        if ((values = (header = originalResponse.getHeader("Via")).getValues()).size() < 2) {
            this.LOG.warn("Not enough Via headers in response: " + originalResponse);
            throw new IOException("Not enough Via headers in response: " + originalResponse);
        }
        SipResponse response = this.m_messageFactory.stripVia(originalResponse);
        this.m_transportLayer.writeResponse(response);
    }
}

