/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.proxy.stateless;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.lastbamboo.common.sip.proxy.LocationService;
import org.lastbamboo.common.sip.proxy.SipRegistrar;
import org.lastbamboo.common.sip.proxy.SipRequestAndResponseForwarder;
import org.lastbamboo.common.sip.proxy.SipRequestForwarder;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.transport.SipTcpTransportLayer;
import org.lastbamboo.common.sip.stack.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnregisteredUriForwarder
implements SipRequestForwarder {
    private final Logger LOG = LoggerFactory.getLogger(UnregisteredUriForwarder.class);
    private final LocationService m_locationService;
    private final ExecutorService m_executor = Executors.newCachedThreadPool();
    private final SipTcpTransportLayer m_transportLayer;
    private final UriUtils m_uriUtils;
    private final SipMessageFactory m_messageFactory;
    private SipRequestAndResponseForwarder m_proxy;
    private final SipRegistrar m_registrar;

    public UnregisteredUriForwarder(LocationService locationService, SipTcpTransportLayer transportLayer, UriUtils uriUtils, SipMessageFactory messageFactory, SipRegistrar registrar) {
        this.m_locationService = locationService;
        this.m_transportLayer = transportLayer;
        this.m_uriUtils = uriUtils;
        this.m_messageFactory = messageFactory;
        this.m_registrar = registrar;
    }

    @Override
    public void forwardSipRequest(Invite request) {
    }

    private void forwardSipRequest(URI uri, Invite request) {
        Collection targetUris;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Forwarding SIP request for URI: " + uri);
        }
        if ((targetUris = this.m_locationService.getTargetSet(uri)).isEmpty()) {
            this.LOG.debug("No targets for URI...");
            this.sendRequestTimeout(request);
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Forwarding to targetUris: " + targetUris);
        }
        Transformer socketAddressTransformer = new Transformer(){

            public Object transform(Object obj) {
                UnregisteredUriForwarder.this.LOG.debug("Transforming: " + obj);
                URI targetUri = (URI)obj;
                UnregisteredUriForwarder.this.LOG.debug("Cast URI...");
                String host = UnregisteredUriForwarder.this.m_uriUtils.getHostInSipUri(targetUri);
                int port = UnregisteredUriForwarder.this.m_uriUtils.getPortInSipUri(targetUri);
                InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                return socketAddress;
            }
        };
        Collection targetSocketAddresses = CollectionUtils.collect((Collection)targetUris, (Transformer)socketAddressTransformer);
        this.LOG.debug("Using socket addresses: " + targetSocketAddresses);
        if (this.m_transportLayer.hasConnectionForAny(targetSocketAddresses)) {
            this.LOG.debug("Writing request using existing connection...");
            this.m_transportLayer.writeRequest(targetSocketAddresses, request);
        } else {
            this.LOG.debug("Creating new connection to forward request...");
            this.connectToAnyTargetAndSendRequest(targetSocketAddresses, request);
        }
    }

    private void sendRequestTimeout(Invite request) {
        InetSocketAddress socketAddress;
        try {
            socketAddress = SipMessageUtils.extractNextHopFromVia((SipMessage)request);
        }
        catch (IOException e) {
            this.LOG.warn("Could not extract Via", (Throwable)e);
            return;
        }
        SipResponse requestTimeout = this.m_messageFactory.createRequestTimeoutResponse((SipMessage)request);
        this.m_transportLayer.writeResponse(socketAddress, requestTimeout);
    }

    private boolean connectToAnyTargetAndSendRequest(Collection targetUris, Invite request) {
        this.LOG.debug("Attempting to connect to " + targetUris.size() + " URIs...");
        for (InetSocketAddress target : targetUris) {
            try {
                if (!this.connectToTargetAndSendRequest(target, (SipMessage)request)) continue;
                return true;
            }
            catch (IOException e) {
                this.LOG.debug("Could not connect to URI: " + target, (Throwable)e);
            }
        }
        this.sendRequestTimeout(request);
        return false;
    }

    private boolean connectToTargetAndSendRequest(InetSocketAddress target, SipMessage request) throws IOException {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Connecting to external URI: " + target);
        }
        return true;
    }
}

