/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec;

import java.io.IOException;
import org.lastbamboo.common.sip.stack.IdleSipSessionListener;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageVisitor;
import org.lastbamboo.common.sip.stack.message.SipMessageVisitorFactory;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.util.SessionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipIoHandler
implements IoHandler {
    private final Logger m_log = LoggerFactory.getLogger(SipIoHandler.class);
    private final SipMessageVisitorFactory m_visitorFactory;
    private static int s_messagesRead = 0;
    private final IdleSipSessionListener m_idleSipSessionListener;

    public SipIoHandler(SipMessageVisitorFactory visitorFactory) {
        this.m_visitorFactory = visitorFactory;
        this.m_idleSipSessionListener = null;
    }

    public SipIoHandler(SipMessageVisitorFactory visitorFactory, IdleSipSessionListener idleSipSessionListener) {
        this.m_visitorFactory = visitorFactory;
        this.m_idleSipSessionListener = idleSipSessionListener;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        if (!(cause instanceof IOException)) {
            this.m_log.warn("Unexpected exception:", cause);
        }
        session.close();
    }

    public final void messageReceived(IoSession session, Object message) throws Exception {
        ++s_messagesRead;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Received message.  Now read: {} ", (Object)s_messagesRead);
        }
        SipMessage sipMessage = (SipMessage)message;
        SipMessageVisitor visitor = this.m_visitorFactory.createVisitor(session);
        sipMessage.accept(visitor);
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Message processing complete for: {}", (Object)sipMessage);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.m_log.debug("Message sent to: {}", (Object)session.getRemoteAddress());
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.m_log.debug("Session opened!!!");
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.m_log.debug("Session closed!!!");
    }

    public void sessionCreated(IoSession session) throws Exception {
        SessionUtil.initialize((IoSession)session);
        session.setIdleTime(IdleStatus.BOTH_IDLE, 260);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.m_log.debug("Killing idle session: {}", (Object)session);
        session.close();
        if (this.m_idleSipSessionListener != null) {
            this.m_idleSipSessionListener.onIdleSession();
        }
    }
}

