/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec;

import java.util.HashMap;
import java.util.Map;

public enum SipMessageType {
    REGISTER("REGISTER"),
    INVITE("INVITE"),
    SIP_2_0("SIP/2.0"),
    DOUBLE_CRLF("\r\n\r\n"),
    UNKNOWN("UNKNOWN");

    private static final Map<String, SipMessageType> s_stringsToEnums;
    private final String m_type;

    public String convert() {
        return this.m_type;
    }

    public static SipMessageType convert(String type) {
        return s_stringsToEnums.get(type);
    }

    public static boolean contains(String type) {
        return s_stringsToEnums.containsKey(type);
    }

    private SipMessageType() {
        this.m_type = "";
    }

    private SipMessageType(String type) {
        this.m_type = type;
    }

    static {
        s_stringsToEnums = new HashMap<String, SipMessageType>();
        for (SipMessageType type : SipMessageType.values()) {
            s_stringsToEnums.put(type.convert(), type);
        }
    }
}

