/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec.decoder;

import java.net.URI;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.commons.lang.math.NumberUtils;
import org.lastbamboo.common.sip.stack.codec.SipMessageType;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.ConsumeToCrlfDecodingState;
import org.littleshoot.util.mina.ConsumeToLinearWhitespaceDecodingState;
import org.littleshoot.util.mina.ConsumeToTerminatorDecodingState;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SipFirstLineDecodingState
extends DecodingStateMachine {
    private final Logger LOG = LoggerFactory.getLogger(SipFirstLineDecodingState.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final CharsetDecoder m_utf8Decoder = UTF_8.newDecoder();
    private final CharsetDecoder m_asciiDecoder = US_ASCII.newDecoder();

    SipFirstLineDecodingState() {
    }

    protected DecodingState init() throws Exception {
        return new MessageTypeDecodingState();
    }

    protected void destroy() throws Exception {
    }

    private final class ReadResponseReasonPhraseState
    extends ConsumeToCrlfDecodingState {
        private ReadResponseReasonPhraseState() {
        }

        protected DecodingState finishDecode(ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            String reasonPhrase = product.getString(SipFirstLineDecodingState.this.m_asciiDecoder);
            out.write((Object)reasonPhrase);
            return null;
        }
    }

    private final class ReadResponseStatusCodeState
    extends ConsumeToLinearWhitespaceDecodingState {
        private ReadResponseStatusCodeState() {
        }

        protected DecodingState finishDecode(byte foundTerminator, ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            String statusCodeString = product.getString(SipFirstLineDecodingState.this.m_asciiDecoder);
            if (!NumberUtils.isNumber((String)statusCodeString)) {
                SipFirstLineDecodingState.this.LOG.warn("Bad status code: " + statusCodeString);
                throw new IllegalArgumentException("Bad status code: " + statusCodeString);
            }
            Integer statusCode = Integer.decode(statusCodeString);
            out.write((Object)statusCode);
            return new ReadResponseReasonPhraseState();
        }
    }

    private final class ReadSipVersionState
    extends ConsumeToCrlfDecodingState {
        private ReadSipVersionState() {
        }

        protected DecodingState finishDecode(ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            String version = product.getString(SipFirstLineDecodingState.this.m_asciiDecoder);
            out.write((Object)version);
            return null;
        }
    }

    private final class ReadRequestUriState
    extends ConsumeToLinearWhitespaceDecodingState {
        private ReadRequestUriState() {
        }

        protected DecodingState finishDecode(byte foundTerminator, ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            String uri = product.getString(SipFirstLineDecodingState.this.m_utf8Decoder);
            out.write((Object)new URI(uri));
            return new ReadSipVersionState();
        }
    }

    private final class ReadLfCrlfDecodingState
    extends ConsumeToCrlfDecodingState {
        private ReadLfCrlfDecodingState() {
        }

        protected DecodingState finishDecode(ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            SipFirstLineDecodingState.this.LOG.debug("Read final LF CR LF");
            return null;
        }
    }

    private final class MessageTypeDecodingState
    extends ConsumeToTerminatorDecodingState {
        private MessageTypeDecodingState() {
            super((byte)32, (byte)13);
        }

        protected DecodingState finishDecode(byte terminator, ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            SipMessageType messageType = this.determineMessageType(terminator, product);
            SipFirstLineDecodingState.this.LOG.debug("Found message type: {}", (Object)messageType);
            out.write((Object)messageType);
            switch (messageType) {
                case SIP_2_0: {
                    return new ReadResponseStatusCodeState();
                }
                case REGISTER: {
                    return new ReadRequestUriState();
                }
                case INVITE: {
                    return new ReadRequestUriState();
                }
                case DOUBLE_CRLF: {
                    return new ReadLfCrlfDecodingState();
                }
                case UNKNOWN: {
                    return new ReadRequestUriState();
                }
            }
            return new ReadRequestUriState();
        }

        private SipMessageType determineMessageType(byte terminator, ByteBuffer product) throws CharacterCodingException {
            if (terminator == 13) {
                SipFirstLineDecodingState.this.LOG.debug("Returning double CRLF");
                return SipMessageType.DOUBLE_CRLF;
            }
            String firstWord = product.getString(SipFirstLineDecodingState.this.m_asciiDecoder);
            if (!SipMessageType.contains(firstWord)) {
                SipFirstLineDecodingState.this.LOG.warn("Unknown message type: '{}'", (Object)firstWord);
                return SipMessageType.UNKNOWN;
            }
            SipFirstLineDecodingState.this.LOG.debug("Matching message type for: {}", (Object)firstWord);
            return SipMessageType.convert(firstWord);
        }
    }
}

